/*  
 * 	odb/file.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_odb.h>

static size_t
odb_get_size (gdl_odb * r)
{
	int i;
	char * tmp;
	FILE * stream = r->_stream;
	fread (&r->size, sizeof(size_t), 1, stream);
	fgetc (stream);
}

static void
odb_set_size (gdl_odb * r)
{
	FILE * stream = r->_stream;
	fwrite (&r->size, sizeof(size_t), 1, stream);
	fprintf (stream, "\n");
}
/**
 * mode :
 *  0 - first time the handler is opened
 *  1 - assume that the file exists. * 
 */
static int
odb_ropen (gdl_odb * r, int mode)
{	
	if (!mode && !gdl_isfile (r->filename))
	{
		// Try to create the file
		r->_stream = gdl_fileopen (r->filename, "w");
		
		if (r->_stream == NULL)
		{
			GDL_ERROR ("Failed to open file for gdl_odb",
                        GDL_EOF);	
		}
		else
		{
			r->size = 0;
			odb_set_size (r);
		}
		
		gdl_fileclose (r->filename, r->_stream);		
	}
	
	r->_stream = gdl_fileopen (r->filename, "r");
	
	if (mode && r->_stream == NULL)
	{
		GDL_ERROR ("Failed to open file for gdl_odb",
                        GDL_EOF);
	}
	
	odb_get_size (r);
	
	return GDL_SUCCESS;	
}

static int
odb_uopen (gdl_odb * r)
{	
	r->_stream = gdl_fileopen (r->filename, "r+");
	
	if (r->_stream == NULL)
	{
		GDL_ERROR ("Failed to open file for gdl_odb",
                        GDL_EOF);
	}
	
	odb_set_size (r);
	
	return GDL_SUCCESS;	
}


static int
odb_close (gdl_odb * r)
{
	gdl_fileclose (r->filename, r->_stream);
	return GDL_SUCCESS;
}
/**
 * Go to the next result
 */
static int
odb_rnext (gdl_odb * r)
{
	int i, ch;
	char * tmp;
	FILE * stream = r->_stream;
	
	// look for -result tag
	tmp = GDL_CALLOC (char, GDL_MAXLINE);
	
	ch  = gdl_get_next_token (tmp, GDL_MAXLINE, stream);
	
	do
	{
		if (!strcmp (tmp, GDL_ODB_TAG))
		{
			break;	
		}
		ch  = gdl_get_next_token (tmp, GDL_MAXLINE, stream);
		
	} while (ch != EOF);
	
	GDL_FREE (tmp);
	
	return 0;
}

/**
 * Go to the last result
 */
static int
odb_rjump (gdl_odb * r, size_t n)
{
	size_t i;
	
	for (i = 0; i < n; i++)
	{
		odb_rnext (r);
	}
}
