/*  
 * 	odb/odb.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_odb.h>

#include "private.c"

gdl_odb *
gdl_odb_alloc (const char * filename)
{
	gdl_odb * r;
	
	r = GDL_MALLOC (gdl_odb, 1);
	
	if (r == 0)
	{
		GDL_ERROR_VAL ("Failed to allocate memory for gdl_odb",
                        GDL_ENOMEM, 0);
	}
	
	r->driver   = NULL;
	r->filename = gdl_string_clone (filename);
	r->header   = gdl_list_alloc (&_oheader_interface);
	
	return r;
}

void
gdl_odb_free (gdl_odb * r)
{
	if (r == 0)
		return;
	GDL_FREE (r->filename);
	gdl_list_free (r->header);
	GDL_FREE (r);
}

#include "file.c"
#include "header.c"
#include "insert.c"
#include "search.c"

size_t
gdl_odb_size (gdl_odb * r)
{
	odb_uopen (r);
	odb_close (r);
	return r->size;
}
