/*  
 * 	odb/private.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_odb.h>

static const char * GDL_ODB_TAG = "<result>";

struct _gdl_odb {
	size_t size;
	char * filename;
	const gdl_odriver     * driver;
	gdl_list              * header;
	FILE *_stream;
};

struct _gdl_oheader
{
	size_t id;
	char * driver_name;
	char * driver_version;
	char * date;
	gdl_meta * meta;
};

static gdl_oheader *
gdl_oheader_alloc (void)
{
	gdl_oheader * header = GDL_MALLOC (gdl_oheader, 1);
	return header;
}

static void
gdl_oheader_free (gdl_oheader * header)
{
	if (header == 0)
		return;
	gdl_meta_free (header->meta);
	GDL_FREE (header->driver_name);
	GDL_FREE (header->driver_version);
	GDL_FREE (header->date);
	GDL_FREE (header);	
}

static void
oheader_free (void * data)
{
	if (data == 0)
		return;
	else
	{
		gdl_oheader * header = (gdl_oheader *) data;
		gdl_oheader_free (header);
	}
}

static gdl_data_interface _oheader_interface =
{
	&oheader_free,
	NULL,
	NULL,
	NULL,
	NULL
};

