/*  
 *  odb/registry.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_odb.h>

#include <gdl/gdl_pstruct_result.h>
#include <gdl/gdl_hstruct_result.h>
#include <gdl/gdl_gpca_result.h>
#include <gdl/gdl_gpca_tag_result.h>
#include <gdl/gdl_gglm_result.h>
#include <gdl/gdl_mosaic_result.h>
#include <gdl/gdl_rho_result.h>

struct _gdl_odriver_registry
{
	gdl_hashtable * drivers;
};

static gdl_odriver_registry _singleton =
{
	NULL
};

gdl_odriver_registry * gdl_odriver_registry_singleton = &_singleton;

gdl_odriver_registry *
gdl_odriver_registry_get ()
{
	if (_singleton.drivers == NULL)
	{
		_singleton.drivers = gdl_hashtable_alloc (gdl_hash_default, 0);
		gdl_odriver_registry_add_driver (&_singleton, gdl_pstruct_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_gpca_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_gpca_tag_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_hstruct_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_gglm_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_mosaic_result_driver);
		gdl_odriver_registry_add_driver (&_singleton, gdl_rho_result_driver);
	}
	return gdl_odriver_registry_singleton;
}

const gdl_odriver *
gdl_odriver_registry_get_driver (gdl_odriver_registry * r, const gdl_string * name)
{
	return gdl_hashtable_lookup (r->drivers, name);
}

int
gdl_odriver_registry_add_driver (gdl_odriver_registry * r, const gdl_odriver * driver)
{
	return gdl_hashtable_add (r->drivers, driver->name, driver, 0);
}
