/*  
 * 	odb/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_odb.h>

typedef struct
{
	int i;
	double x;
} test_object;

//static void
//test_meta (void)
//{
//	int status;
//	FILE * stream;
//	gdl_meta_tag * t1, * t2;
//	gdl_meta * tmp;
//	gdl_meta * meta = gdl_meta_alloc();
//	
//	t1 = gdl_meta_tag_alloc ();
//	gdl_meta_tag_name (t1, "TAG1");
//	gdl_meta_tag_value (t1, "VTAG1");
//	gdl_meta_add (meta, t1);
//	t2 = gdl_meta_tag_alloc ();
//	gdl_meta_tag_name (t2, "TAG2");
//	gdl_meta_tag_value (t2, "VTAG2");
//	gdl_meta_add (meta, t2);
//		
//	stream = gdl_fileopen ("test.meta", "w");
//	
//	gdl_meta_fprintf (stream, meta);
//	
//	gdl_fileclose ("test.meta", stream);
//	
//	stream = gdl_fileopen ("test.meta", "r");
//	
//	tmp = gdl_meta_fscanf (stream);
//	
//	gdl_fileclose ("test.meta", stream);
//	
//	gdl_list_pop_init (tmp->tags);
//	gdl_list_pop_init (meta->tags);
//	
//	status = 1;
//	
//	t1 = (gdl_meta_tag *) gdl_list_pop_front (tmp->tags);
//	t2 = (gdl_meta_tag *) gdl_list_pop_front (meta->tags);
//	do
//	{
//		status &= !strcmp (t1->name, t2->name);
//		status &= !strcmp (t1->value, t2->value);
//		t1 = (gdl_meta_tag *) gdl_list_pop_front (tmp->tags);
//		t2 = (gdl_meta_tag *) gdl_list_pop_front (meta->tags);
//	}
//	while (t1 != NULL && t2 != NULL);
//	
//	gdl_test (status != 1, "gdl_meta_* functions seem to be ok");
//	
//	gdl_meta_free (tmp);
//	gdl_meta_free (meta);
//}

static gdl_meta * 
test_object_meta (const void * vresult)
{
	test_object * result = (test_object *) vresult;
	gdl_meta_tag * t;
	gdl_meta * m = gdl_meta_alloc ();
	
	t = gdl_meta_tag_alloc();
	gdl_meta_tag_name (t, "test.i");
	gdl_meta_tag_value (t, "%d", result->i);
	gdl_meta_add (m, t);
	t = gdl_meta_tag_alloc();
	gdl_meta_tag_name (t, "test.x");
	gdl_meta_tag_value (t, "%g", result->x);
	gdl_meta_add (m, t);
	
	return m;	
}

static void * 
test_object_fread (FILE * stream)
{
	size_t status;
	test_object * result;
	
	result = GDL_MALLOC (test_object, 1);
	
	status = fread (&result->i, sizeof(int), 1, stream);
	GDL_FREAD_STATUS (status, 1);
	status = fread (&result->x, sizeof(double), 1, stream);
	GDL_FREAD_STATUS (status, 1);
	
	return result;
}

static int 
test_object_fwrite (FILE * stream, const void * vresult)
{
	size_t status;
	test_object * result = (test_object *) vresult;
	
	status = fwrite (&result->i, sizeof(int), 1, stream);
	GDL_FWRITE_STATUS (status, 1);
	status = fwrite (&result->x, sizeof(double), 1, stream);
	GDL_FWRITE_STATUS (status, 1);
	
	return GDL_SUCCESS;
}

static const gdl_odriver test_object_driver =
{
	"test_object",
	"1.0",
	&test_object_meta,
	&test_object_fread,
	&test_object_fwrite,
	NULL
};

void
test_insert (void)
{
	size_t i;
	test_object * result;
	gdl_odb * r = gdl_odb_alloc ("test.res");
	
	result = GDL_MALLOC (test_object, 1);
	
	result->i = 5;
	result->x = 10.0;
	
	for (i = 0; i < 5; i++)
	{
		gdl_odb_insert (r, &test_object_driver, result);
	}
	
	gdl_odb_free (r);
}

void
test_summary (void)
{
	gdl_odb * r = gdl_odb_alloc ("test.res");
	
	printf ("SUMMARY 0\n");
	gdl_odb_fsummary (r, stdout, 0);
	printf ("SUMMARY 1\n");
	gdl_odb_fsummary (r, stdout, 1);
	
	gdl_odb_free (r);
}

void
test_search (void)
{
	size_t i;
	gdl_odb * r = gdl_odb_alloc ("test.res");
	
	for (i = 1; i <= 5; i++)
	{
		test_object * res = (test_object *) gdl_odb_search	(r, &test_object_driver, i);
		printf ("result = %d %g\n", res->i, res->x);
		GDL_FREE (res);
	}
	
	gdl_odb_free (r);	
}

int
main (void)
{
	//test_meta ();
	test_insert ();
	test_summary ();
	test_search ();
	exit (gdl_test_summary());
}
