/*  
 *  pca/gdl_pca.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_PCA_H__
#define __GDL_PCA_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_math.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string * name;
	size_t     size;
	int (*alloc)(void * vstate, size_t size1, size_t size2);
	int (*free) (void * vstate);
	int (*perform)(void * vstate, gdl_matrix * X, size_t naxe);
	int (*wperform)(void * vstate, gdl_matrix * X, const gdl_vector * w, size_t naxe);
	int (*perform_transpose)(void * vstate, gdl_matrix * X, size_t naxe);
	int (*wperform_transpose)(void * vstate, gdl_matrix * X, const gdl_vector * w, size_t naxe);
	gdl_matrix * (*rotation)(void * vstate);
	gdl_vector * (*weights)(void * vstate);	
} gdl_pca_workspace_type;

typedef struct _gdl_pca_workspace gdl_pca_workspace;

gdl_pca_workspace * gdl_pca_workspace_alloc (const gdl_pca_workspace_type * T);
void gdl_pca_workspace_free (gdl_pca_workspace * w);

int gdl_pca_workspace_perform (gdl_pca_workspace * w, gdl_matrix * X);
int gdl_pca_workspace_wperform (gdl_pca_workspace * w, gdl_matrix * X, const gdl_vector * weights);
int gdl_pca_workspace_const_perform (gdl_pca_workspace * w, const gdl_matrix * X);
int gdl_pca_workspace_const_wperform (gdl_pca_workspace * w, const gdl_matrix * X, const gdl_vector * weights);

int gdl_pca_workspace_perform_transpose (gdl_pca_workspace * w, gdl_matrix * X);
int gdl_pca_workspace_wperform_transpose (gdl_pca_workspace * w, gdl_matrix * X, const gdl_vector * weights);
int gdl_pca_workspace_const_perform_transpose (gdl_pca_workspace * w, const gdl_matrix * X);
int gdl_pca_workspace_const_wperform_transpose (gdl_pca_workspace * w, const gdl_matrix * X, const gdl_vector * weights);

const gdl_matrix * gdl_pca_workspace_projection (const gdl_pca_workspace * r);
const gdl_matrix * gdl_pca_workspace_rotation (const gdl_pca_workspace * r);
const gdl_vector * gdl_pca_workspace_weights (const gdl_pca_workspace * r);
const gdl_vector * gdl_pca_workspace_tracy_widom (const gdl_pca_workspace * r);
double gdl_pca_workspace_tot_var (const gdl_pca_workspace * r);

size_t gdl_pca_workspace_scree_threshold (const gdl_pca_workspace * r, const double threshold);

GDL_VAR const gdl_pca_workspace_type * gdl_pca_standard;
GDL_VAR const gdl_pca_workspace_type * gdl_pca_covariance;
GDL_VAR const gdl_pca_workspace_type * gdl_pca_correlation;


__END_DECLS

#endif /* __GDL_PCA_H__ */
