/* permutation/file.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_permutation.h>

#define IN_FORMAT "%lu"

int
gdl_permutation_fread (FILE * stream, gdl_permutation * p)
{
  size_t n = p->size ;

  size_t * data = p->data ;

  size_t items = fread (data, sizeof (size_t), n, stream);
  
  if (items != n)
    {
      GDL_ERROR ("fread failed", GDL_EFAILED);
    }
      
  return GDL_SUCCESS;
}

int
gdl_permutation_fwrite (FILE * stream, const gdl_permutation * p)
{
  size_t n = p->size ;

  size_t * data = p->data ;
  
  size_t items = fwrite (data, sizeof (size_t), n, stream);
  
  if (items != n)
    {
      GDL_ERROR ("fwrite failed", GDL_EFAILED);
    }

  return GDL_SUCCESS;
}

int
gdl_permutation_fprintf (FILE * stream, const gdl_permutation * p, const char *format)
{
  size_t n = p->size ;
  
  size_t * data = p->data ;
  
  size_t i;

  for (i = 0; i < n; i++)
    {
      int status = fprintf (stream, format, data[i]);

      if (status < 0)
        {
          GDL_ERROR ("fprintf failed", GDL_EFAILED);
        }
    }

  return GDL_SUCCESS;
}

int
gdl_permutation_fscanf (FILE * stream, gdl_permutation * p)
{
  size_t n = p->size ;
  
  size_t * data = p->data ;

  size_t i;

  for (i = 0; i < n; i++)
    {
      unsigned long j ;  

      /* FIXME: what if size_t != unsigned long ??? 

         want read in size_t but have to read in unsigned long to avoid
         error from compiler */

      int status = fscanf (stream, IN_FORMAT, &j);  

      if (status != 1)
        {
          GDL_ERROR ("fscanf failed", GDL_EFAILED);
        }

      data[i] = j;
    }

  return GDL_SUCCESS;
}

