/* permutation/gdl_permutation.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_PERMUTATION_H__
#define __GDL_PERMUTATION_H__

#include <stdlib.h>
#include <gdl/gdl_types.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_check_range.h>

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

__BEGIN_DECLS

struct gdl_permutation_struct
{
  size_t size;
  size_t *data;
};

typedef struct gdl_permutation_struct gdl_permutation;

gdl_permutation *gdl_permutation_alloc (const size_t n);
gdl_permutation *gdl_permutation_calloc (const size_t n);
void gdl_permutation_init (gdl_permutation * p);
void gdl_permutation_free (gdl_permutation * p);
int gdl_permutation_memcpy (gdl_permutation * dest, const gdl_permutation * src);

int gdl_permutation_fread (FILE * stream, gdl_permutation * p);
int gdl_permutation_fwrite (FILE * stream, const gdl_permutation * p);
int gdl_permutation_fscanf (FILE * stream, gdl_permutation * p);
int gdl_permutation_fprintf (FILE * stream, const gdl_permutation * p, const char *format);

size_t gdl_permutation_size (const gdl_permutation * p);
size_t * gdl_permutation_data (const gdl_permutation * p);

size_t gdl_permutation_get (const gdl_permutation * p, const size_t i);
int gdl_permutation_swap (gdl_permutation * p, const size_t i, const size_t j);

int gdl_permutation_valid (gdl_permutation * p);
void gdl_permutation_reverse (gdl_permutation * p);
int gdl_permutation_inverse (gdl_permutation * inv, const gdl_permutation * p);
int gdl_permutation_next (gdl_permutation * p);
int gdl_permutation_prev (gdl_permutation * p);
int gdl_permutation_mul (gdl_permutation * p, const gdl_permutation * pa, const gdl_permutation * pb);

int gdl_permutation_linear_to_canonical (gdl_permutation * q, const gdl_permutation * p);
int gdl_permutation_canonical_to_linear (gdl_permutation * p, const gdl_permutation * q);

size_t gdl_permutation_inversions (const gdl_permutation * p);
size_t gdl_permutation_linear_cycles (const gdl_permutation * p);
size_t gdl_permutation_canonical_cycles (const gdl_permutation * q);

#ifdef HAVE_INLINE

extern inline
size_t
gdl_permutation_get (const gdl_permutation * p, const size_t i)
{
#if GDL_RANGE_CHECK
  if (i >= p->size)
    {
      GDL_ERROR_VAL ("index out of range", GDL_EINVAL, 0);
    }
#endif
  return p->data[i];
}

#endif /* HAVE_INLINE */

__END_DECLS

#endif /* __GDL_PERMUTATION_H__ */
