/*  
 * 	phase/gdl_phase_em.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_PHASE_EM_H__
#define __GDL_PHASE_EM_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>
 
 __BEGIN_DECLS

typedef struct
{
	const gdl_view * v;
	const gdl_mask * m;
	const gdl_rng * r;
	double pmt;
} gdl_phase_em_param;

gdl_phase_em_param * gdl_phase_em_param_alloc (const gdl_view * v, const gdl_mask * m, const gdl_rng * rng, double pmt);
void gdl_phase_em_param_free (gdl_phase_em_param * P);

typedef struct
{
    const char *name;
    size_t     size;
    int  (*alloc)   (void * state, const gdl_phase_em_param * P);
    int  (*free)    (void * state);
    int  (*init_rng)    (void * state);
    int  (*init_static)    (void * state, void * start);
    int  (*iterate) (void * state);
    double (*loglikelihood) (void * state);
    double (*residual_abs) (void * state);
    double (*residual_sq) (void * state);
    void * (*result) (void * state);
    int (*fread)   (FILE * stream, void * vstate);
    int (*fwrite)  (FILE * stream, const void * state);
} gdl_phase_em_workspace_type;

typedef struct
{
	const gdl_phase_em_workspace_type * type;
	gdl_phase_em_param * param;
	void  *state;
} gdl_phase_em_workspace;

gdl_phase_em_workspace * gdl_phase_em_workspace_alloc (const gdl_phase_em_workspace_type * T, gdl_phase_em_param * P);
int gdl_phase_em_workspace_init_rng (gdl_phase_em_workspace * w);
int gdl_phase_em_workspace_init_static (gdl_phase_em_workspace * w, void * result);
void gdl_phase_em_workspace_free (gdl_phase_em_workspace * w);
int gdl_phase_em_workspace_iterate (gdl_phase_em_workspace * w);

double gdl_phase_em_workspace_loglikelihood (const gdl_phase_em_workspace * w);
double gdl_phase_em_workspace_residual_abs (const gdl_phase_em_workspace * w);
double gdl_phase_em_workspace_residual_sq (const gdl_phase_em_workspace * w);

void * gdl_phase_em_workspace_result (const gdl_phase_em_workspace * w);

int gdl_phase_em_workspace_fread (FILE * stream, gdl_phase_em_workspace * w);
int gdl_phase_em_workspace_fwrite (FILE * stream, const gdl_phase_em_workspace * w);

GDL_VAR const gdl_phase_em_workspace_type * gdl_phase_em_hview;
//GDL_VAR const gdl_phase_em_workspace_type * gdl_phase_em_hmap;
 
__END_DECLS

#endif
