/*  
 *  ppca/gdl_ppca.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_PPCA_H__
#define __GDL_PPCA_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_rng.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string * name;
	size_t     size;
	int (*alloc)(void * vstate, size_t size1, size_t size2, const gdl_rng * rng);
	int (*free) (void * vstate);
	int (*perform)(void * vstate, gdl_matrix * X, size_t naxe, double eps, size_t maxi);
	int (*wperform)(void * vstate, gdl_matrix * X, const gdl_vector * w, size_t naxe, double eps, size_t maxi);
//	int (*perform_transpose)(void * vstate, gdl_matrix * X, size_t naxe, double eps, size_t maxi);
//	int (*wperform_transpose)(void * vstate, gdl_matrix * X, const gdl_vector * w, size_t naxe, double eps, size_t maxi);
    gdl_matrix * (*projection)(void * vstate);
	gdl_matrix * (*rotation)(void * vstate);
	gdl_vector * (*weights)(void * vstate);
} gdl_ppca_workspace_type;

typedef struct _gdl_ppca_workspace gdl_ppca_workspace;

gdl_ppca_workspace * gdl_ppca_workspace_alloc (const gdl_ppca_workspace_type * T, const gdl_rng * rng);
void gdl_ppca_workspace_free (gdl_ppca_workspace * w);

int gdl_ppca_workspace_perform (gdl_ppca_workspace * w, gdl_matrix * X, size_t naxe, double eps, size_t maxi);
int gdl_ppca_workspace_wperform (gdl_ppca_workspace * w, gdl_matrix * X, const gdl_vector * weights, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_const_perform (gdl_ppca_workspace * w, const gdl_matrix * X, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_const_wperform (gdl_ppca_workspace * w, const gdl_matrix * X, const gdl_vector * weights, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_perform_transpose (gdl_ppca_workspace * w, gdl_matrix * X, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_wperform_transpose (gdl_ppca_workspace * w, gdl_matrix * X, const gdl_vector * weights, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_const_perform_transpose (gdl_ppca_workspace * w, const gdl_matrix * X, size_t naxe, double eps, size_t maxi);
//int gdl_ppca_workspace_const_wperform_transpose (gdl_ppca_workspace * w, const gdl_matrix * X, const gdl_vector * weights, size_t naxe, double eps, size_t maxi);

const gdl_matrix * gdl_ppca_workspace_projection (const gdl_ppca_workspace * r);
const gdl_matrix * gdl_ppca_workspace_rotation (const gdl_ppca_workspace * r);
const gdl_vector * gdl_ppca_workspace_weights (const gdl_ppca_workspace * r);
const gdl_vector * gdl_ppca_workspace_tracy_widom (const gdl_ppca_workspace * r);

GDL_VAR const gdl_ppca_workspace_type * gdl_ppca_standard;
GDL_VAR const gdl_ppca_workspace_type * gdl_ppca_covariance;
GDL_VAR const gdl_ppca_workspace_type * gdl_ppca_correlation;


__END_DECLS

#endif /* __GDL_PCA_H__ */
