/*  
 *  pstruct/gdl_pstruct.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_PSTRUCT_H__
#define __GDL_PSTRUCT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_fuzzy.h>

__BEGIN_DECLS

typedef struct
{
  gdl_string * name;
  size_t size;
  int (*alloc)(void * vstate, void * data, gdl_rng * rng, size_t k);
  int (*free)(void * vstate);
	int (*init) (void * state);
	int (*init_update) (void * state, const int * aidx, const int * lidx, const void * db, double (*get_q)(const void * db, size_t k, size_t i), double (*get_f)(const void * db, size_t k, size_t l, size_t a));
	int (*iterate) (void * state);
	int (*iterate_update) (void * state, const int * aidx, const int * lidx);
	int (*imputation) (void * state);
	double (*loglik) (const void * state);
	double (*res_abs) (const void * state);
	double (*res_sq) (const void * state);
	double (*get_pop_q) (const void * state, size_t k);
	double (*get_acc_q) (const void * state, size_t k, size_t i);
	double (*get_loc_f) (const void * state, size_t k, size_t l, size_t a);
	size_t (*get_loc_f_max) (const void * state, size_t k, size_t l);
	size_t (*get_loc_f_size) (const void * state, size_t l);
} gdl_pstruct_workspace_type;

typedef struct 
{
	const gdl_pstruct_workspace_type * type;
	gdl_gview_wrapper * gwrap;
	gdl_hview         * hview;
	void * state;
	size_t k;
	gdl_rng * rng;	
	int * aidx;
	int * lidx;
	double residual;
	double tw_residual;
} gdl_pstruct_workspace;

gdl_pstruct_workspace * gdl_pstruct_workspace_galloc (const gdl_pstruct_workspace_type * T, gdl_gview_wrapper * gw, gdl_rng * rng, size_t k); 
gdl_pstruct_workspace * gdl_pstruct_workspace_halloc (const gdl_pstruct_workspace_type * T, gdl_hview * h, gdl_rng * rng, size_t k);

void gdl_pstruct_workspace_free (gdl_pstruct_workspace * state);
int gdl_pstruct_workspace_init (gdl_pstruct_workspace * state);
int gdl_pstruct_workspace_init_update (gdl_pstruct_workspace * state, const int * aidx, const int * lidx, const void * db, double (*get_q)(const void * db, size_t k, size_t i), double (*get_f)(const void * db, size_t k, size_t l, size_t a));
int gdl_pstruct_workspace_iterate (gdl_pstruct_workspace *state);
int gdl_pstruct_workspace_iterate_update (gdl_pstruct_workspace *state);
int gdl_pstruct_workspace_imputation (gdl_pstruct_workspace *state);
double gdl_pstruct_workspace_loglikelihood (const gdl_pstruct_workspace * state);
double gdl_pstruct_workspace_residual_sq (const gdl_pstruct_workspace * state);
double gdl_pstruct_workspace_residual_abs (const gdl_pstruct_workspace * state);

size_t gdl_pstruct_workspace_ploidy (const gdl_pstruct_workspace * state);
size_t gdl_pstruct_workspace_population_size (const gdl_pstruct_workspace * state);
size_t gdl_pstruct_workspace_accession_size (const gdl_pstruct_workspace * state);
size_t gdl_pstruct_workspace_locus_size (const gdl_pstruct_workspace * state);
double gdl_pstruct_workspace_get_population_q (const gdl_pstruct_workspace * f, size_t pop);
double gdl_pstruct_workspace_get_accession_q (const gdl_pstruct_workspace * f, size_t pop, size_t indiv);
size_t gdl_pstruct_workspace_get_accession_q_max (const gdl_pstruct_workspace * f, size_t indiv);
double gdl_pstruct_workspace_get_locus_f (const gdl_pstruct_workspace * f, size_t pop, size_t loc, size_t allele);
size_t gdl_pstruct_workspace_get_locus_f_max (const gdl_pstruct_workspace * f, size_t pop, size_t loc);
size_t gdl_pstruct_workspace_get_locus_f_size (const gdl_pstruct_workspace * f, size_t loc);

int gdl_pstruct_workspace_compute_residual_cov (gdl_pstruct_workspace *state);

//GDL_VAR const gdl_pstruct_workspace_type * gdl_pstruct_em_mixture;
GDL_VAR const gdl_pstruct_workspace_type * gdl_pstruct_em_gmixture;
GDL_VAR const gdl_pstruct_workspace_type * gdl_pstruct_em_gadmixture;
GDL_VAR const gdl_pstruct_workspace_type * gdl_pstruct_em_hadmixture;

__END_DECLS

#endif /* GDL_PSTRUCT_H */
