/*  
 *  pstruct/residual.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_gmatrix.h> 
#include <gdl/gdl_gview_wrapper.h> 
#include <gdl/gdl_hview.h>
#include <gdl/gdl_pca.h>
#include <gdl/gdl_ppca.h>
#include <gdl/gdl_pstruct.h>

static double
_gdl_pstruct_get_expected (const gdl_pstruct_workspace * state, size_t i, size_t l, size_t a) 
{
	size_t k;
	double q, f, e = 0;
	
	for (k = 0; k < state->k; k++)
	{
		q = gdl_pstruct_workspace_get_accession_q (state, k, i);
		f = gdl_pstruct_workspace_get_locus_f (state, k, l, a);
		e += q*f;
	}
	
	return e;
}

static gdl_gmatrix *
_gdl_pstruct_residual_gmatrix (const gdl_pstruct_workspace * state)
{
	size_t i, ii, j, k, l, nr, nl, na, pl;
	double x, e;
	gdl_gmatrix * gm = gdl_gmatrix_wrapper_alloc (gdl_gmatrix_allele, state->gwrap, gdl_true, gdl_false);
	gdl_matrix  * m  = gm->data;
	
	pl = gdl_pstruct_workspace_ploidy (state);
	nr = gdl_gmatrix_accession_size (gm);
	nl = gdl_gmatrix_locus_size (gm);
	
	for (i = 0; i < nr; i++)
	{
		ii = gdl_gview_wrapper_accession_idx_c (state->gwrap, i);
		for (j = 0; j < nl; j++)
		{
			 if (!gdl_gmatrix_locus_is_missing (gm, i, j))
			 {
			 	 na = gdl_gmatrix_locus_column_size (gm, j);
			 	 for (l = 0; l < na; l++)
			 	 {
			 	 	 e = _gdl_pstruct_get_expected (state, ii, j, l);
			 	 	 x = gdl_gmatrix_locus_column_get (gm, i, j, l);
			 	 	 x -= pl*e;
			 	 	 gdl_gmatrix_locus_column_set (gm, i, j, l, x);
			 	 }
			 }
			 else
			 {
			 	 gdl_gmatrix_locus_set_all (gm, i, j, 0);
			 }
		}	
	}
	
	return gm;
}

static gdl_gmatrix *
_gdl_pstruct_residual_matrix (const gdl_pstruct_workspace *state)
{
	if (state->gwrap)
	{
		 return _gdl_pstruct_residual_gmatrix (state);	
	}
	else if (state->hview)
	{
		//return _gdl_pstruct_residual_hmatrix (state);	
	}
}

int
gdl_pstruct_workspace_compute_residual_cov (gdl_pstruct_workspace * state)
{
	size_t i, j;
	//gdl_ppca_workspace * ppca;
	gdl_pca_workspace * pca;
	gdl_gmatrix * GX = _gdl_pstruct_residual_matrix (state);
	gdl_matrix * X, * XX = NULL;
	gdl_vector * w;
	double x;
	
	//ppca = gdl_ppca_workspace_alloc (gdl_ppca_covariance, state->rng);
	pca = gdl_pca_workspace_alloc (gdl_pca_standard);
	
	X = GX->data;
	w = GX->rw;
	
	if (X->size2 > X->size1)
	{
		XX = gdl_matrix_alloc (X->size2, X->size1);
		gdl_matrix_transpose_memcpy (XX, X);
		
		gdl_pca_workspace_wperform_transpose (pca, XX, w);
		
		gdl_matrix_free (XX);
	}
	else
	{
		gdl_pca_workspace_wperform (pca, X, w);
   }

	//gdl_ppca_workspace_wperform (ppca, X, w, 2, 1.e-3, 10);
	
	//state->residual    = gdl_vector_get (gdl_ppca_workspace_weights (ppca), 0);
	//state->tw_residual = gdl_vector_get (gdl_ppca_workspace_tracy_widom (ppca), 0);
	
	state->residual    = gdl_vector_get (gdl_pca_workspace_weights (pca), 0);
	//state->tw_residual = gdl_vector_get (gdl_pca_workspace_tracy_widom (pca), 0);

	//gdl_ppca_workspace_free (ppca);
	gdl_pca_workspace_free (pca);
	gdl_gmatrix_free (GX);
	
	return GDL_SUCCESS;
}
