/*  
 *  pstruct/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_runtime.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_reader.h>
#include <gdl/gdl_pstruct.h>


gdl_gview_reader_type *
_reader_type (size_t t)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    switch (t)
    {
    	case 1 :
    		gdl_gview_reader_type_missing (type, "missing");
    		return type;
    	case 2 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 3 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 4 :
    		gdl_gview_reader_type_missing (type, "N");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, "");
		    gdl_gview_reader_type_ploidy (type, 1);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
    		return type;
    }
}

gdl_gview *
_read_data (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview * v;
	
	type = _reader_type (t);
	
	reader = gdl_gview_reader_alloc (type);
	
	file = gdl_string_sprintf ("examples/data%d.txt", t);
	
	gdl_gview_reader_open (reader, file);
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	gdl_string_free (file);
	
	return v;	
}

int
test_create (void)
{
	int status;
	size_t i, iter;
	gdl_gview * g;
	gdl_mask * m = NULL;
	gdl_mask * u;
	gdl_clustering * c;
	gdl_pstruct_workspace * wf;
	const gdl_runtime_type * T;
	gdl_runtime * r;
    
    gdl_runtime_env_setup ();
      
    T = gdl_runtime_default;
  
    r = gdl_runtime_alloc (T);
    
    g = _read_data (4);
	
	m = gdl_mask_uninformative (g, m, GDL_LOCUS);
	
	u = gdl_mask_uninformative (g, m, GDL_ACCESSION);
	
	gdl_mask_free (u);
	
	c = gdl_gview_accession_clustering (g, m);
	
	wf = gdl_pstruct_workspace_alloc (g,
	                                m,
	                                c,
	                                r->rng,
	                                2);
	
	gdl_pstruct_workspace_init (wf);
	
	i = 0;
	do
	{
		i++;
		status = gdl_pstruct_workspace_iterate (wf);
		printf ("ITER %d STATUS %d\n", i, status);fflush(stdout);
		//printf (" LOGLIKELIHOOD %g\n", gdl_pstruct_workspace_loglikelihood (wf));
		printf (" RESIDUAL      %g\n", wf->abs_res);
		if (wf->abs_res > 1.e-5)
			status=GDL_CONTINUE;
	} while (status == GDL_CONTINUE && i < 100);
	
	gdl_pstruct_workspace_free (wf);
	
	gdl_gview_free (g);
	
	gdl_mask_free (m);
	
	gdl_clustering_free (c);	
	
	return GDL_SUCCESS;
}

int
main (void)
{
    test_create ();	
	exit (gdl_test_summary());
}
