/*  
 *  rho/gdl_rho_result.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_RHO_RESULT_H__
#define __GDL_RHO_RESULT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_result.h>
#include <gdl/gdl_rho.h>

__BEGIN_DECLS

typedef struct
{
	size_t N;
	size_t L;
	gdl_rho_params  * theta;
} gdl_rho_result;

gdl_rho_result * gdl_rho_result_alloc (gdl_rho * rho);
void gdl_rho_result_free (gdl_rho_result * r);

gdl_rho_result * gdl_rho_result_fread (FILE * stream);
int gdl_rho_result_fwrite (FILE * stream, const gdl_rho_result * r);
int gdl_rho_result_fprintf (FILE * stream, const gdl_rho_result * r);

GDL_VAR const gdl_odriver * gdl_rho_result_driver;

__END_DECLS

#endif
