/*  
 *  mosaic/param.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_nan.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_rho.h>

gdl_rho_params *
gdl_rho_params_alloc (const size_t L)
{
	size_t i;
	gdl_rho_params * p;
	
	p = GDL_CALLOC (gdl_rho_params, 1);
	
	p->L = L;
	p->lambda = GDL_MALLOC (double, L-1);
	for (i = 0; i < L-1; i++)
	{
		p->lambda[i]=1;
	}
	
	return p;
} 

void
gdl_rho_params_free (gdl_rho_params * p)
{
	if (p)
	{
	 	GDL_FREE (p->lambda);
	 	GDL_FREE (p);
	} 	
}

gdl_rho_params *
gdl_rho_params_clone (const gdl_rho_params * p)
{
	if (p)
	{
		gdl_rho_params * c = gdl_rho_params_alloc (p->L);
		memcpy (c->lambda, p->lambda, sizeof(double)*(p->L-1));
		c->rho = p->rho;
		c->theta = p->theta;
		c->proba = p->proba;
		return c;
	}
}

void
gdl_rho_params_init (gdl_rho_params * p, size_t N)
{
	size_t i;
	
	p->rho   = 2.302585;
	p->theta = 0;
	for (i = 1; i < N; i++)
	{
		p->theta +=	1.0/i;
	}
	p->theta = 1.0/p->theta;
}
