/*  
 *  rho/proba.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_rho.h>

double
gdl_rho_hmm_obs_proba (const gdl_rho * hmm, size_t i, size_t k, size_t j, size_t l)
{
	if (!gdl_rho_data_is_missing(hmm->data, j, l)
	 && !gdl_rho_data_is_missing(hmm->data, i, l))
	{
		double x,y; 
		size_t anc  = gdl_rho_data_get_allele (hmm->data, i, l);
		size_t obs  = gdl_rho_data_get_allele (hmm->data, j, l);
		x = k+hmm->param->theta;
		y = 0;
		if (anc == obs)
		{
			y += (double)k/x;
			//return 1-hmm->param->theta;
		}
		y += hmm->param->theta/(x*hmm->data->NA[l]);
		return y;
		//return hmm->param->theta/(hmm->data->NA[l]-1);
	}
	else
	{
		return 1.0;
	}
}

double
gdl_rho_hmm_mut_proba (const gdl_rho * hmm, size_t K, size_t l)
{
	return hmm->param->theta/((K+hmm->param->theta)*hmm->data->NA[l]);
}

double
gdl_rho_hmm_norec_proba (const gdl_rho * hmm, size_t k, size_t l, double d)
{
	if (d >= 0.0)
	{
		return exp(-hmm->param->rho*hmm->param->lambda[l]*d/k);
	}
	else
	{
		return exp(-hmm->param->rho*hmm->param->lambda[l]/k);
	}
}

double *
gdl_rho_transition_proba (const gdl_rho * r, size_t i, size_t K, size_t l)
{
	size_t k;
	double z, * t = GDL_CALLOC (double, K);
	
	z = 1-gdl_rho_hmm_norec_proba (r, K, l, r->data->D[l]);
	for (k = 0; k < K; k++)
	{
		t[k] = z/K;
		if (i == k) t[k] += 1-z;
	}
	
	return t;
}
