/* rng/file.c
 * 
 * Copyright (C) 2003 Olaf Lenz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_rng.h>

static const gdl_rng_type * gdl_rng_type_fread (FILE * stream);
static int gdl_rng_type_fwrite (FILE * stream, const gdl_rng_type * T);

gdl_rng * 
gdl_rng_fread (FILE * stream)
{
  size_t status, n;	
  void * state;
  gdl_rng * rng;
  
  rng = GDL_MALLOC (gdl_rng, 1);
  
  rng->type = gdl_rng_type_fread (stream);
  GDL_FREAD_STATUS (rng->type==0, 0);
  
  n      = rng->type->size;
  state  = gdl_malloc (n);
  status = fread (state, 1, n, stream);
  GDL_FREAD_STATUS (status, n);
  rng->state = state;
  
  return rng;
}

static const gdl_rng_type *
gdl_rng_type_fread (FILE * stream)
{
	int status;
	char * t;
	const gdl_rng_type * T;
	
	t = gdl_string_fread (stream);	
	
	if ( !strcmp (t, gdl_rng_mt19937->name) )
	{
		T = gdl_rng_mt19937;
	} 
	else
	{
		T = NULL;	
	}
	
	GDL_FREE (t);
	
	return T;
}

int
gdl_rng_fwrite (FILE * stream, const gdl_rng * r)
{
  int status;
  size_t n     = r->type->size;
  char * state = r->state;
  
  status = gdl_rng_type_fwrite (stream, r->type);
  GDL_FWRITE_STATUS (status, 0);
  status = fwrite (state, 1, n, stream);
  GDL_FWRITE_STATUS (status, n);
  
  return GDL_SUCCESS;
}

static int
gdl_rng_type_fwrite (FILE * stream, const gdl_rng_type * T)
{
	return gdl_string_fwrite (stream, T->name);
}
