/* roots/fdfsolver.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Reid Priedhorsky, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_roots.h>

gdl_root_fdfsolver *
gdl_root_fdfsolver_alloc (const gdl_root_fdfsolver_type * T)
{

  gdl_root_fdfsolver * s = (gdl_root_fdfsolver *) malloc (sizeof (gdl_root_fdfsolver));

  if (s == 0)
    {
      GDL_ERROR_VAL ("failed to allocate space for root solver struct",
                        GDL_ENOMEM, 0);
    };

  s->state = malloc (T->size);

  if (s->state == 0)
    {
      free (s);         /* exception in constructor, avoid memory leak */

      GDL_ERROR_VAL ("failed to allocate space for root solver state",
                        GDL_ENOMEM, 0);
    };

  s->type = T ;
  s->fdf = NULL;

  return s;
}

int
gdl_root_fdfsolver_set (gdl_root_fdfsolver * s, gdl_function_fdf * f, double root)
{
  s->fdf = f;
  s->root = root;

  return (s->type->set) (s->state, s->fdf, &(s->root));
}

int
gdl_root_fdfsolver_iterate (gdl_root_fdfsolver * s)
{
  return (s->type->iterate) (s->state, s->fdf, &(s->root));
}

void
gdl_root_fdfsolver_free (gdl_root_fdfsolver * s)
{
  free (s->state);
  free (s);
}

const char *
gdl_root_fdfsolver_name (const gdl_root_fdfsolver * s)
{
  return s->type->name;
}

double
gdl_root_fdfsolver_root (const gdl_root_fdfsolver * s)
{
  return s->root;
}


