/*
 *  run/runtime.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_rng.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_runtime.h>

const gdl_runtime_type *
gdl_runtime_env_setup (void)
{
  return gdl_runtime_default;
}

static const gdl_rng_type *
runtime_default_rng_setup (void)
{
	gdl_rng_env_setup ();
	
	return gdl_rng_default;		
}

static const gdl_runtime_type default_type =
{
	"gdl_runtime_default",
   &runtime_default_rng_setup
};

const gdl_runtime_type *gdl_runtime_default = &default_type;
