/*
 *  run/gdl_runtime.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_RUNTIME_H__
#define __GDL_RUNTIME_H__

#include <gdl/gdl_rng.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_rng.h>

__BEGIN_DECLS

typedef struct
{
    const gdl_string * name;
    const gdl_rng_type * (*rng_setup) (void);
} gdl_runtime_type;

typedef struct gdl_runtime {
	 const gdl_runtime_type  * type;
    gdl_rng                 * rng;
    FILE                    * logger;
} gdl_runtime;

const gdl_runtime_type * gdl_runtime_env_setup (void);

gdl_runtime * gdl_runtime_alloc (const gdl_runtime_type * T);
void gdl_runtime_free (gdl_runtime * r);

gdl_runtime * gdl_runtime_fread (FILE * stream);
int gdl_runtime_fwrite (FILE * stream, const gdl_runtime * run);

gdl_rng * gdl_runtime_get_rng (gdl_runtime * r);

GDL_VAR const gdl_runtime_type * gdl_runtime_default;

__END_DECLS

#endif
