/*
 *  run/runtime.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_rng.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_runtime.h>

gdl_runtime *
gdl_runtime_alloc (const gdl_runtime_type * T)
{
	const gdl_rng_type * Trng;
	gdl_runtime * r;
	
	r = GDL_MALLOC (gdl_runtime, 1);
	
	r->type   = T;
	
	Trng = (T->rng_setup)();
	
	if (Trng == 0)
	{
		GDL_FREE (r);
		GDL_ERROR_VAL ("failed to setup the random generator",
                        GDL_ENOMEM, 0);
	}
	
	r->rng    = gdl_rng_alloc ( Trng );
	
	r->logger = NULL;
	
	return r;
}

void
gdl_runtime_free (gdl_runtime * r)
{
	if (r == 0)	return;
	if (r->rng) gdl_rng_free (r->rng);
	r->logger = NULL;
	r->type   = NULL;
	GDL_FREE (r);
}

void
gdl_runtime_set_rng (gdl_runtime * r, gdl_rng *rng)
{
	r->rng = rng;	
}

gdl_rng *
gdl_runtime_get_rng (gdl_runtime * r)
{
	return r->rng;	
}


