/*
 *  snp/fread.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_snp_data.h>
#include <gdl/gdl_snp_map.h>
#include <gdl/gdl_snp_chromosome.h>

gdl_snp_data *
gdl_snp_data_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		size_t N, L, P;
		gdl_string * name;
		gdl_snp_data * v;
			
		status = fread (&N, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&L, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&P, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		name = gdl_string_fread (stream);
		GDL_FREAD_STATUS (name!=0, 1);
		
		if (!strcmp (name, gdl_snp_data_genotype->name))
		{
			v = gdl_snp_data_alloc (gdl_snp_data_genotype, N, L, P);
			status = fread (v->data, sizeof(unsigned char), N*L, stream);
			GDL_FREAD_STATUS (status, N*L);
		}
		else if (!strcmp (name, gdl_snp_data_haplotype->name))
		{
			v = gdl_snp_data_alloc (gdl_snp_data_haplotype, N, L, P);
			status = fread (v->data, sizeof(unsigned char), N*L*P, stream);
			GDL_FREAD_STATUS (status, N*L*P);
		}
		else
		{
			GDL_FREAD_STATUS (0!=0, 1);	
		}
		
		return v;
	}
	return 0;
}

gdl_snp *
gdl_snp_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		unsigned char has;
		gdl_snp * snp;
		gdl_string * rs, * a0, * a1;
		long pos;
		
		rs = gdl_string_fread (stream);
		GDL_FREAD_STATUS (rs!=0, 1);
		a0 = gdl_string_fread (stream);
		GDL_FREAD_STATUS (a0!=0, 1);
		a1 = gdl_string_fread (stream);
		GDL_FREAD_STATUS (a1!=0, 1);
		status = fread (&pos, sizeof (long), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		snp = gdl_snp_alloc (rs, a0, a1, pos);
		
		status = fread (&snp->rate, sizeof (double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&snp->distance, sizeof (double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
				
		status = fread (&has, sizeof (unsigned char), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		if (has == '1')
		{
			snp->annot = gdl_snp_annot_fread (stream);
			GDL_FREAD_STATUS (snp->annot!=0, 1);
		}
		
		status = fread (&snp->polypop, sizeof (unsigned char), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&snp->ignore, sizeof (unsigned char), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		return snp;
	}
	return 0;	
}

gdl_snp_map *
gdl_snp_map_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		size_t i;
		gdl_snp_map * chrom;
		
		status = fread (&i, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		chrom = gdl_snp_map_alloc (i);
		
		for (i = 0; i < chrom->size; i++)
		{
			chrom->snps[i] = gdl_snp_fread (stream);
			GDL_FREAD_STATUS (chrom->snps[i]!=0, 1);
		}
		
		return chrom;
	}
	return 0;	
}

gdl_snp_chromosome *
gdl_snp_chromosome_fread (FILE * stream)
{
	if (stream)
	{
		size_t i;
		int status;
		unsigned char has;
		gdl_snp_chromosome * v;
		
		v = GDL_CALLOC (gdl_snp_chromosome, 1);
		
		status = fread (&v->npop, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		v->pops = GDL_MALLOC (gdl_snp_data *, v->npop); 
		
		for (i = 0; i < v->npop; i++)
		{
			v->pops[i] = gdl_snp_data_fread (stream);
			GDL_FREAD_STATUS (v->pops[i]!=0, 1);
			v->snp_data_T = v->pops[i]->T;
			status = fread (&has, sizeof(unsigned char), 1, stream);
			GDL_FREAD_STATUS (status, 1);
			if (has == 'y')
			{
				if (!v->cnvs) v->cnvs = GDL_CALLOC (gdl_cnv_data *, v->npop);
				v->cnvs[i] = gdl_cnv_data_fread (stream);
			   GDL_FREAD_STATUS (v->cnvs[i]!=0, 1);
			}
		}
		
		v->chrom = gdl_snp_map_fread (stream);
		GDL_FREAD_STATUS (v->chrom!=0, 1);
		
		if (v->npop > 1)
		{
			v->idx = GDL_MALLOC (size_t *, v->chrom->size);
			for (i = 0; i < v->chrom->size; i++)
			{
				v->idx[i] = GDL_MALLOC (size_t, v->npop);
				status = fread (v->idx[i], sizeof(size_t), v->npop, stream);
				GDL_FREAD_STATUS (status, v->npop);
			}	
		}

		return v;
	}
	return 0;
}
