/*
 *  snp/gdl_cnv_data.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_CNV_DATA_H__
#define __GDL_CNV_DATA_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>

__BEGIN_DECLS

typedef struct
{
	size_t idx;
	gdl_string * name;
	long start;
	long end;
} gdl_cnv_clone;

gdl_cnv_clone * gdl_cnv_clone_alloc (const gdl_string * name, long start, long end);
void gdl_cnv_clone_free (gdl_cnv_clone * c);
gdl_cnv_clone * gdl_cnv_clone_fread (FILE * stream);
int gdl_cnv_clone_fwrite (FILE * stream, const gdl_cnv_clone * c);

typedef struct
{
	size_t N;
	size_t L;
	gdl_cnv_clone ** clones;
	double        * data;
} gdl_cnv_data;

gdl_cnv_data * gdl_cnv_data_alloc (const size_t N, const size_t L);
void gdl_cnv_data_free (gdl_cnv_data * v);

gdl_boolean gdl_cnv_data_is_missing (const gdl_cnv_data * v, size_t i, size_t j);
double gdl_cnv_data_get (const gdl_cnv_data * v, size_t i, size_t j);
void gdl_cnv_data_set (const gdl_cnv_data * v, size_t i, size_t j, const double x);

gdl_cnv_data * gdl_cnv_data_fread (FILE * stream);
gdl_cnv_data * gdl_cnv_data_fscanf (FILE * stream);
int gdl_cnv_data_fwrite (FILE * stream, const gdl_cnv_data * v);
int gdl_cnv_data_fprintf (FILE * stream, const gdl_cnv_data * v);

__END_DECLS

#endif
