/*
 *  snp/gdl_snp.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_H__
#define __GDL_SNP_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_snp_annotation.h>

__BEGIN_DECLS


typedef struct
{
	size_t idx;
	gdl_string * rs;
	gdl_string ** alleles;
	long   position; // physical (bp)
	double rate;     // (cM) / (pb)
	double distance; // genetics (cM)
	gdl_snp_annot * annot;
	unsigned char polypop;
	unsigned char ignore;
} gdl_snp;

gdl_snp * gdl_snp_alloc (gdl_string * rs, gdl_string * allele0, gdl_string * allele1, long position);
void gdl_snp_free (gdl_snp * snp);
gdl_snp * gdl_snp_clone (const gdl_snp * snp);
void gdl_snp_annot_dico_add_count (gdl_snp_annot_dico * dico, const gdl_snp * snp);

gdl_snp * gdl_snp_fread (FILE * stream);
int gdl_snp_fwrite (FILE * stream, const gdl_snp * snp);
int gdl_snp_fprintf (FILE * stream, const gdl_snp * snp);

typedef struct
{
	gdl_hashtable * table;
} gdl_snp_table;

typedef struct
{
	const gdl_string * chrom;
	const gdl_string * feature;
	const gdl_string * snp;
} gdl_snp_table_entry;

gdl_snp_table * gdl_snp_table_fscanf (FILE * stream);
gdl_boolean gdl_snp_table_is_inside (const gdl_snp_table * table, const gdl_string * chrom, const gdl_string * gene, const gdl_string * rs);
gdl_snp_table_entry ** gdl_snp_table_get_entries (const gdl_snp_table * table, size_t * n);
void gdl_snp_table_free (gdl_snp_table * table);

typedef struct
{
	gdl_hashtable * table;
} gdl_feature_table;

gdl_feature_table * gdl_feature_table_fscanf (FILE * stream);
gdl_boolean gdl_feature_table_is_inside (const gdl_feature_table * table, const gdl_string * chrom, const gdl_string * feature);
void gdl_feature_table_free (gdl_feature_table * table); 
gdl_boolean gdl_feature_table_has_chromosome (const gdl_feature_table * table, const gdl_string * chrom);

__END_DECLS

#endif
