/*
 *  snp/gdl_snp_annotation.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_ANNOTATION_H__
#define __GDL_SNP_ANNOTATION_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>

__BEGIN_DECLS

typedef struct
{
	size_t idx;
	long id;
	gdl_string * name;
} gdl_snp_annot_gene_entry;

gdl_snp_annot_gene_entry * gdl_snp_annot_gene_entry_alloc (gdl_string * name, long id);
void gdl_snp_annot_gene_entry_free (gdl_snp_annot_gene_entry * g);
gdl_snp_annot_gene_entry * gdl_snp_annot_gene_entry_clone (const gdl_snp_annot_gene_entry * e);
gdl_snp_annot_gene_entry * gdl_snp_annot_gene_entry_fread (FILE * stream);
int gdl_snp_annot_gene_entry_fwrite (FILE * stream, const gdl_snp_annot_gene_entry * g);

typedef struct
{
	size_t idx;
	size_t col;
	size_t count;
	gdl_string * name;
	double (*prior)(void);
} gdl_snp_annot_entry;

gdl_snp_annot_entry * gdl_snp_annot_entry_alloc (gdl_string * name);
void gdl_snp_annot_entry_free (gdl_snp_annot_entry * e);
gdl_snp_annot_entry * gdl_snp_annot_entry_clone (const gdl_snp_annot_entry * e);
gdl_snp_annot_entry * gdl_snp_annot_entry_fread (FILE * stream);
int gdl_snp_annot_entry_fwrite (FILE * stream, gdl_snp_annot_entry * e);

typedef struct
{
	size_t gene_id;
	size_t func_id;
} gdl_snp_annot_gene;

gdl_snp_annot_gene * gdl_snp_annot_gene_alloc (size_t g, size_t f);
void gdl_snp_annot_gene_free (gdl_snp_annot_gene * g);
gdl_snp_annot_gene * gdl_snp_annot_gene_clone (const gdl_snp_annot_gene * g);
gdl_snp_annot_gene * gdl_snp_annot_gene_fread (FILE * stream);
int gdl_snp_annot_gene_fwrite (FILE * stream, const gdl_snp_annot_gene *g);

typedef struct
{
	size_t size;
	size_t * ids;
} gdl_snp_annot_level;

gdl_snp_annot_level * gdl_snp_annot_level_alloc (const size_t size);
void gdl_snp_annot_level_free (gdl_snp_annot_level * l);
gdl_snp_annot_level * gdl_snp_annot_level_clone (const gdl_snp_annot_level * l);
gdl_snp_annot_level * gdl_snp_annot_level_fread (FILE * stream);
int gdl_snp_annot_level_fwrite (FILE * stream, const gdl_snp_annot_level * l);

typedef struct
{
	gdl_snp_annot_gene  * gene;
	gdl_snp_annot_level * geno;
	gdl_snp_annot_level * tran;
	gdl_snp_annot_level * prot;
} gdl_snp_annot;

gdl_snp_annot * gdl_snp_annot_alloc (void);
void gdl_snp_annot_free (gdl_snp_annot * a);
gdl_snp_annot * gdl_snp_annot_clone (const gdl_snp_annot * a);
gdl_snp_annot * gdl_snp_annot_fread (FILE * stream);
int gdl_snp_annot_fwrite (FILE * stream, const gdl_snp_annot * a);

typedef struct _gdl_snp_annot_reader gdl_snp_annot_reader;

gdl_snp_annot_reader * gdl_snp_annot_reader_alloc (void);
void gdl_snp_annot_reader_free (gdl_snp_annot_reader * reader);

typedef struct
{
	size_t ngene;
	size_t nfunc;
	size_t ngeno;
	size_t ntran;
	size_t nprot;
	size_t count;
	gdl_snp_annot_gene_entry  ** gene;
	gdl_snp_annot_entry ** func;
	gdl_snp_annot_entry ** geno;
	gdl_snp_annot_entry ** tran;
	gdl_snp_annot_entry ** prot;
	gdl_snp_annot_entry * unknown;
} gdl_snp_annot_dico;

gdl_snp_annot_dico * gdl_snp_annot_dico_alloc (const gdl_snp_annot_reader * reader);
gdl_snp_annot_dico * gdl_snp_annot_dico_clone (const gdl_snp_annot_dico * dico);
void gdl_snp_annot_dico_free (gdl_snp_annot_dico * d);
void gdl_snp_annot_dico_reset_count (gdl_snp_annot_dico * d);
int gdl_snp_annot_dico_fprintf_count (const gdl_snp_annot_dico * dico, const gdl_string * chrom, FILE * stream);
void gdl_snp_annot_dico_copy_count (gdl_snp_annot_dico * d1, const gdl_snp_annot_dico * d2);

gdl_snp_annot_dico * gdl_snp_annot_dico_fread (FILE * stream);
int gdl_snp_annot_dico_fwrite (FILE * stream, const gdl_snp_annot_dico * d);


__END_DECLS

#endif
