/*
 *  snp/gdl_snp_chromosome.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_CHROMOSOME_H__
#define __GDL_SNP_CHROMOSOME_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_cnv_data.h>
#include <gdl/gdl_snp_data.h>
#include <gdl/gdl_snp_map.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string        * name;
	size_t npop;
	gdl_snp_map        * chrom;     // snp_map
	gdl_snp_data       ** pops;     // snp_data by pop
	gdl_cnv_data       ** cnvs;     // cnv_data by pop
	size_t             ** idx;      // the index of snp in each data set
	FILE * logger;
	const gdl_snp_annot_dico * dico;
	const gdl_snp_data_type  * snp_data_T;
} gdl_snp_chromosome;

gdl_snp_chromosome * gdl_snp_chromosome_alloc (const gdl_string * name, gdl_string ** popdirs, const size_t npop, const gdl_snp_data_format * format);
void gdl_snp_chromosome_free (gdl_snp_chromosome * v);

int * gdl_snp_chromosome_get_genotypes (const gdl_snp_chromosome * v, size_t snp, size_t *n);
int gdl_snp_chromosome_get_genotype (const gdl_snp_chromosome * v, size_t pop, size_t indiv, size_t snp);
int gdl_snp_chromosome_get_haplotype (const gdl_snp_chromosome * v, size_t pop, size_t indiv, size_t snp, size_t k);

gdl_boolean gdl_snp_chromosome_is_polymorphic (const gdl_snp_chromosome * v, size_t pop, size_t snp);
size_t gdl_snp_chromosome_select_snp (gdl_snp_chromosome * c, const double fmin, const double gmin, const gdl_boolean poly_pop);
double gdl_snp_chromosome_compute_LD (const gdl_snp_chromosome * c, const size_t snp1, const size_t snp2);

double gdl_snp_chromosome_get_pop_frequency (const gdl_snp_chromosome * c, size_t pop, size_t snp);
double gdl_snp_chromosome_get_frequency (const gdl_snp_chromosome * c, size_t snp);
double gdl_snp_chromosome_get_MAF (const gdl_snp_chromosome * c, size_t snp, size_t * which);

gdl_cnv_clone ** gdl_snp_chromosome_get_cnv_clones (const gdl_snp_chromosome * c, long from, long to, size_t * n);

gdl_snp_chromosome * gdl_snp_chromosome_fread (FILE * stream);
int gdl_snp_chromosome_fwrite (FILE * stream, const gdl_snp_chromosome * v);

int gdl_snp_chromosome_gmap (gdl_snp_chromosome * chrom, FILE * stream);
int gdl_snp_annot_reader_parse (gdl_snp_annot_reader * r, gdl_snp_chromosome * chrom, FILE * stream);

FILE * gdl_snp_chromosome_set_logger (gdl_snp_chromosome * c, FILE * logger);

__END_DECLS

#endif
