/*
 *  snp/gdl_snp_genome.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_GENOME_H__
#define __GDL_SNP_GENOME_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_snp_data.h>
#include <gdl/gdl_snp_map.h>
#include <gdl/gdl_snp_annotation.h>
#include <gdl/gdl_snp_chromosome.h>

__BEGIN_DECLS

typedef struct
{
	size_t nchrom;
	gdl_string      * dbdir;
	gdl_string    ** chroms;
	gdl_snp_annot_dico * dico;  // annotation dictionary
} gdl_snp_genome;

gdl_snp_genome * gdl_snp_genome_alloc (const gdl_string * config_file, const gdl_snp_data_format * format, const gdl_string * dbdir);
void gdl_snp_genome_free (gdl_snp_genome * v);
size_t gdl_snp_genome_size (const gdl_snp_genome * g);
gdl_snp_chromosome * gdl_snp_genome_get (const gdl_snp_genome * g, size_t i);
void gdl_snp_genome_rm (gdl_snp_genome * v);

gdl_snp_genome * gdl_snp_genome_fread (FILE * stream);
int gdl_snp_genome_fwrite (FILE * stream, const gdl_snp_genome * v);

int gdl_snp_genome_annotation (gdl_snp_genome * g, const gdl_string * annot_dir);
int gdl_snp_genome_cnv (gdl_snp_genome * g, const gdl_string * cnv_dir);
int gdl_snp_genome_gmap (gdl_snp_genome * g, const gdl_string * gmap_dir);

__END_DECLS

#endif
