/*
 *  snp/gdl_snp_map.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_SNP_MAP_H__
#define __GDL_SNP_MAP_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_snp.h>

__BEGIN_DECLS

typedef struct
{
	size_t size;
	gdl_snp ** snps;
} gdl_snp_map;

gdl_snp_map * gdl_snp_map_alloc (const size_t size);
void gdl_snp_map_free (gdl_snp_map * l);
size_t  gdl_snp_map_size (const gdl_snp_map * l);
gdl_snp * gdl_snp_map_get (const gdl_snp_map * l, size_t i);
void gdl_snp_map_set (const gdl_snp_map * l, size_t i, gdl_snp * snp);

gdl_snp_map * gdl_snp_map_fread (FILE * stream);
gdl_snp_map * gdl_snp_map_fscanf (FILE * steam);
int gdl_snp_map_fwrite (FILE * stream, const gdl_snp_map * l);
int gdl_snp_map_fprintf (FILE * stream, const gdl_snp_map * l);

__END_DECLS

#endif
