/*
 *  snp/chrom.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_snp_map.h>
#include <gdl/gdl_snp_data.h>
#include <gdl/gdl_snp_chromosome.h>

double
gdl_snp_chromosome_compute_LD (const gdl_snp_chromosome * c, const size_t snp1, const size_t snp2)
{
	size_t i, j, k, n=0;
	double r, x, y, xy=0, xx=0, yy=0, x2=0, y2=0;
	gdl_boolean ok;
	
	for (i = 0; i < c->npop; i++)
	{
		ok  = gdl_snp_chromosome_is_polymorphic (c, i, snp1);
		ok &= gdl_snp_chromosome_is_polymorphic (c, i, snp2);
		if (ok)
		{
			if (c->snp_data_T == gdl_snp_data_genotype)
			{ 
				for (j = 0; j < c->pops[i]->N; j++)
				{
					x = gdl_snp_chromosome_get_genotype (c, i, j, snp1);
					y = gdl_snp_chromosome_get_genotype (c, i, j, snp2);
					if (x >=0 && y >=0)
					{
						x--;y--;
						xx += x;
						yy += y;
						x2 += x*x;
						y2 += y*y;
						xy += x*y;
						n++;
					}
				}
			}
			else
			{
				for (j = 0; j < c->pops[i]->N; j++)
				{
					for(k = 0; k < c->pops[i]->P; k++)
					{ 
						x = gdl_snp_chromosome_get_haplotype (c, i, j, snp1, k);
						y = gdl_snp_chromosome_get_haplotype (c, i, j, snp2, k);
						if (x >=0 && y >=0)
						{
							x--;y--;
							xx += x;
							yy += y;
							x2 += x*x;
							y2 += y*y;
							xy += x*y;
							n++;
						}
					}
				}	
			}
		}
	}
	if (n)
	{
		x2 -= xx*xx/n;
		y2 -= yy*yy/n;
		x2 /= n;
		y2 /= n;
		r = ((xy - xx*yy/n)/n);
		r *= r;
		return r/(x2*y2);
	}
	else
	{
		return 0;
	}
}
