/*
 *  snp/snp.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_snp.h>

gdl_snp *
gdl_snp_alloc (gdl_string * rs, gdl_string * allele0, gdl_string * allele1, long position)
{
	gdl_snp * s;
	
	s = GDL_CALLOC (gdl_snp, 1);
	
	s->rs = rs;
	s->alleles = GDL_MALLOC (gdl_string *, 2);
	s->alleles[0] = allele0;
	s->alleles[1] = allele1;
	s->position   = position;
	s->polypop    = 'y';
	s->ignore     = 'n';
	
	return s;
}

void
gdl_snp_free (gdl_snp * snp)
{
	if (snp)
	{
		GDL_FREE (snp->rs);
		GDL_FREE (snp->alleles[0]);
		GDL_FREE (snp->alleles[1]);
		GDL_FREE (snp->alleles);
		gdl_snp_annot_free (snp->annot);
		GDL_FREE (snp);
	}
}

gdl_snp *
gdl_snp_clone (const gdl_snp * snp)
{
	if (snp)
	{
		gdl_snp * c;
		
		c = gdl_snp_alloc (gdl_string_clone (snp->rs),
		                   gdl_string_clone (snp->alleles[0]),
		                   gdl_string_clone (snp->alleles[1]),
		                   snp->position);
		
		c->polypop = snp->polypop;
		c->ignore  = snp->ignore;
		c->annot   = gdl_snp_annot_clone (snp->annot);
		
		return c;
	}
	return 0;	
}
