#define OVERFLOW_ERROR(result) do { (result)->val = GDL_POSINF; (result)->err = GDL_POSINF; GDL_ERROR ("overflow", GDL_EOVRFLW); } while(0)

#define UNDERFLOW_ERROR(result) do { (result)->val = 0.0; (result)->err = GDL_DBL_MIN; GDL_ERROR ("underflow", GDL_EUNDRFLW); } while(0)

#define INTERNAL_OVERFLOW_ERROR(result) do { (result)->val = GDL_POSINF; (result)->err = GDL_POSINF; return GDL_EOVRFLW; } while(0)

#define INTERNAL_UNDERFLOW_ERROR(result) do { (result)->val = 0.0; (result)->err = GDL_DBL_MIN; return GDL_EUNDRFLW; } while(0)

#define DOMAIN_ERROR(result) do { (result)->val = GDL_NAN; (result)->err = GDL_NAN; GDL_ERROR ("domain error", GDL_EDOM); } while(0)

#define DOMAIN_ERROR_MSG(msg, result) do { (result)->val = GDL_NAN; (result)->err = GDL_NAN; GDL_ERROR ((msg), GDL_EDOM); } while(0)

#define DOMAIN_ERROR_E10(result) do { (result)->val = GDL_NAN; (result)->err = GDL_NAN; (result)->e10 = 0 ; GDL_ERROR ("domain error", GDL_EDOM); } while(0)

#define OVERFLOW_ERROR_E10(result) do { (result)->val = GDL_POSINF; (result)->err = GDL_POSINF; (result)->e10 = 0; GDL_ERROR ("overflow", GDL_EOVRFLW); } while(0)
#define UNDERFLOW_ERROR_E10(result) do { (result)->val = 0.0; (result)->err = GDL_DBL_MIN; (result)->e10 = 0; GDL_ERROR ("underflow", GDL_EUNDRFLW); } while(0)


#define OVERFLOW_ERROR_2(r1,r2) do { (r1)->val = GDL_POSINF; (r1)->err = GDL_POSINF; (r2)->val = GDL_POSINF ; (r2)->err=GDL_POSINF; GDL_ERROR ("overflow", GDL_EOVRFLW); } while(0)

#define UNDERFLOW_ERROR_2(r1,r2) do { (r1)->val = 0.0; (r1)->err = GDL_DBL_MIN; (r2)->val = 0.0 ; (r2)->err = GDL_DBL_MIN; GDL_ERROR ("underflow", GDL_EUNDRFLW); } while(0)

#define DOMAIN_ERROR_2(r1,r2) do { (r1)->val = GDL_NAN; (r1)->err = GDL_NAN;  (r2)->val = GDL_NAN; (r2)->err = GDL_NAN;  GDL_ERROR ("domain error", GDL_EDOM); } while(0)




