/* specfunc/gdl_sf_elementary.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Author:  G. Jungman */

/* Miscellaneous elementary functions and operations.
 */
#ifndef __GDL_SF_ELEMENTARY_H__
#define __GDL_SF_ELEMENTARY_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_sf_result.h>

__BEGIN_DECLS


/* Multiplication.
 *
 * exceptions: GDL_EOVRFLW, GDL_EUNDRFLW
 */
int gdl_sf_multiply_e(const double x, const double y, gdl_sf_result * result);
double gdl_sf_multiply(const double x, const double y);


/* Multiplication of quantities with associated errors.
 */
int gdl_sf_multiply_err_e(const double x, const double dx, const double y, const double dy, gdl_sf_result * result);


__END_DECLS

#endif /* __GDL_SF_ELEMENTARY_H__ */
