/* statistics/outlier.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Jim Davies, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <stdlib.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_sort.h>
#include <gdl/gdl_statistics.h>
 
size_t
gdl_stats_outlier_one_sided (size_t outlier[], const double data[], const size_t stride, const size_t n, const double q, const double f)
{
	size_t i, nout = 0;
	double q1, q2, iq, * copy;
	
	copy = GDL_MALLOC (double, n);
	
	memcpy (copy, data, sizeof (double)*n);
	
	gdl_sort (copy, 1, n);
	
	if (f > 0)
	{
		q1 = gdl_stats_min (copy, 1, n);
		q2 = gdl_stats_quantile_from_sorted_data (copy, 1, n, q);
		
	}
	else if (f < 0)
	{
		q2 = gdl_stats_max (copy, 1, n);
		q1 = gdl_stats_quantile_from_sorted_data (copy, 1, n, q);
	}
	iq = q2-q1;
	
	for (i = 0; i < n; i++)
	{
		if (f > 0 && data[i] > q2 + f*iq)
		{
			outlier[i] = 1;
		}
		else if (f < 0 && data[i] < q1 + f*iq)
		{
			outlier[i] = 1;
		}
		else
		{
			outlier[i] = 0;	
		}
		nout += outlier[i];
	}
	
	GDL_FREE (copy);
	
	return nout;
}

size_t
gdl_stats_outlier_double_sided (size_t outlier[], const double data[], const size_t stride, const size_t n, const double q, const double f)
{
	size_t i, nout=0;
	double q1, q2, iq, * copy;
	
	copy = GDL_MALLOC (double, n);
	
	memcpy (copy, data, sizeof (double)*n);
	
	gdl_sort (copy, 1, n);
	
	q1 = gdl_stats_quantile_from_sorted_data (copy, 1, n, 1-q);
	q2 = gdl_stats_quantile_from_sorted_data (copy, 1, n, q);
	iq = q2-q1;
	
	for (i = 0; i < n; i++)
	{
		if (data[i] > q2 + f*iq)
		{
			outlier[i] = 1;
		}
		else if (data[i] < q1 - f*iq)
		{
			outlier[i] = 1;
		}
		else
		{
			outlier[i] = 0;	
		}
		nout+=outlier[i];
	}
	
	GDL_FREE (copy);
	
	return nout;
}

