/* statistics/test_int_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Jim Davies, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void FUNCTION (test, func) (const size_t stridea, const size_t strideb);

void
FUNCTION (test, func) (const size_t stridea, const size_t strideb)
{
  /* sample sets of integers */
  size_t i;
  const size_t ina = 20, inb = 20;

  const BASE raw1[] = {1, 2, 3, 4, 5, 6} ;
  
  const BASE irawa[] =
  {17, 18, 16, 18, 12,
   20, 18, 20, 20, 22,
   20, 10, 8, 12, 16,
   16, 18, 20, 18, 21};

  const BASE irawb[] =
  {19, 20, 22, 24, 10,
   25, 20, 22, 21, 23,
   20, 10, 12, 14, 12,
   20, 22, 24, 23, 17};

  BASE * sorted ;

  BASE * test1 = (BASE *) malloc (stridea * 6 * sizeof(BASE));
  BASE * igroupa = (BASE *) malloc (stridea * ina * sizeof(BASE));
  BASE * igroupb = (BASE *) malloc (strideb * inb * sizeof(BASE));

  double rel = 1e-10 ;

  for (i = 0 ; i < ina ; i++)
    igroupa[i * stridea] = irawa[i] ;

  for (i = 0 ; i < inb ; i++)
    igroupb[i * strideb] = irawb[i] ;

  for (i = 0 ; i < 6 ; i++)
    test1[i * stridea] = raw1[i] ;



  {
    double mean = FUNCTION(gdl_stats,mean) (igroupa, stridea, ina);
    double expected = 17.0;
    gdl_test_rel (mean,expected, rel, NAME(gdl_stats) "_mean (integer)");
  }

  {
    double mean = FUNCTION(gdl_stats,mean) (test1, stridea, 6);
    double expected = 3.5;
    gdl_test_rel (mean,expected, rel, NAME(gdl_stats) "_mean (fractional)");
  }

  {
    double mean = FUNCTION(gdl_stats,mean) (igroupa, stridea, ina);
    double var = FUNCTION(gdl_stats,variance_with_fixed_mean) (igroupa, stridea, ina, mean);
    double expected = 13.7;
    gdl_test_rel (var, expected, rel, NAME(gdl_stats) "_variance_with_fixed_mean");
  }

  {
    double mean = FUNCTION(gdl_stats,mean) (igroupa, stridea, ina);
    double sd = FUNCTION(gdl_stats,sd_with_fixed_mean) (igroupa, stridea, ina, mean);
    double expected = 3.70135110466435;
    gdl_test_rel (sd, expected, rel, NAME(gdl_stats) "_sd_with_fixed_mean");
  }

  {
    double var = FUNCTION(gdl_stats,variance) (igroupa, stridea, ina);
    double expected = 14.4210526315789;
    gdl_test_rel (var, expected, rel, NAME(gdl_stats) "_variance");
  }

  {
    double sd_est = FUNCTION(gdl_stats,sd) (igroupa, stridea, ina);
    double expected = 3.79750610685209;
    gdl_test_rel (sd_est, expected, rel, NAME(gdl_stats) "_sd");
  }

  {
    double absdev = FUNCTION(gdl_stats,absdev) (igroupa, stridea, ina);
    double expected = 2.9;
    gdl_test_rel (absdev, expected, rel, NAME(gdl_stats) "_absdev");
  }

  {
    double skew = FUNCTION(gdl_stats,skew) (igroupa, stridea, ina);
    double expected = -0.909355923168064;
    gdl_test_rel (skew, expected, rel, NAME(gdl_stats) "_skew");
  }

  {
    double kurt = FUNCTION(gdl_stats,kurtosis) (igroupa, stridea, ina);
    double expected = -0.233692524908094 ;
    gdl_test_rel (kurt, expected, rel, NAME(gdl_stats) "_kurtosis");
  }

  {
    double c = FUNCTION(gdl_stats,covariance) (igroupa, stridea, igroupb, strideb, inb);
    double expected = 14.5263157894737;
    gdl_test_rel (c, expected, rel, NAME(gdl_stats) "_covariance");
  }


  {
    double pv = FUNCTION(gdl_stats,pvariance) (igroupa, stridea, ina, igroupb, strideb, inb);
    double expected = 18.8421052631579;
    gdl_test_rel (pv, expected, rel, NAME(gdl_stats) "_pvariance");
  }

  {
    double t = FUNCTION(gdl_stats,ttest) (igroupa, stridea, ina, igroupb, strideb, inb);
    double expected = -1.45701922702927;
    gdl_test_rel (t, expected, rel, NAME(gdl_stats) "_ttest");
  }

  {
    int max = FUNCTION(gdl_stats,max) (igroupa, stridea, ina);
    int expected = 22;
    gdl_test (max != expected,
              NAME(gdl_stats) "_max (%d observed vs %d expected)", max, expected);
  }

  {
    int min = FUNCTION(gdl_stats,min) (igroupa, stridea, ina);
    int expected = 8;
    gdl_test (min != expected,
              NAME(gdl_stats) "_min (%d observed vs %d expected)", min, expected);
  }

  {
    BASE min, max;
    BASE expected_max = 22;
    BASE expected_min = 8;
    
    FUNCTION(gdl_stats,minmax) (&min, &max, igroupa, stridea, ina);
 
    gdl_test  (max != expected_max,
               NAME(gdl_stats) "_minmax max (" OUT_FORMAT " observed vs " OUT_FORMAT " expected)", 
               max, expected_max);
    gdl_test  (min != expected_min,
               NAME(gdl_stats) "_minmax min (" OUT_FORMAT " observed vs " OUT_FORMAT " expected)", 
               min, expected_min);
  }

  {
    int max_index = FUNCTION(gdl_stats,max_index) (igroupa, stridea, ina);
    int expected = 9 ;
    gdl_test (max_index != expected,
              NAME(gdl_stats) "_max_index (%d observed vs %d expected)",
              max_index, expected);
  }

  {
    int min_index = FUNCTION(gdl_stats,min_index) (igroupa, stridea, ina);
    int expected = 12 ;
    gdl_test (min_index != expected,
              NAME(gdl_stats) "_min_index (%d observed vs %d expected)",
              min_index, expected);
  }

  {
    size_t min_index, max_index;
    size_t expected_max_index = 9;
    size_t expected_min_index = 12;

    FUNCTION(gdl_stats,minmax_index) (&min_index, &max_index, igroupa, stridea, ina);

    gdl_test  (max_index != expected_max_index,
               NAME(gdl_stats) "_minmax_index max (%u observed vs %u expected)", 
               max_index, expected_max_index);
    gdl_test  (min_index != expected_min_index,
               NAME(gdl_stats) "_minmax_index min (%u observed vs %u expected)", 
               min_index, expected_min_index);
  }


  sorted = (BASE *) malloc(stridea * ina * sizeof(BASE)) ;

  for (i = 0 ; i < ina ; i++)
    sorted[stridea * i] = igroupa[stridea * i] ;


  TYPE(gdl_sort)(sorted, stridea, ina);

  {
    double median = FUNCTION(gdl_stats,median_from_sorted_data)(sorted, stridea, ina) ;
    double expected = 18;
    gdl_test_rel (median,expected, rel,
                  NAME(gdl_stats) "_median_from_sorted_data (even)");
  }

  {
    double median = FUNCTION(gdl_stats,median_from_sorted_data)(sorted, stridea, ina - 1) ;
    double expected = 18;
    gdl_test_rel (median,expected, rel,
                  NAME(gdl_stats) "_median_from_sorted_data (odd)");
  }


  {
    double zeroth = FUNCTION(gdl_stats,quantile_from_sorted_data)(sorted, stridea, ina, 0.0) ;
    double expected = 8;
    gdl_test_rel (zeroth,expected, rel,
                  NAME(gdl_stats) "_quantile_from_sorted_data (0)");
  }

  {
    double top = FUNCTION(gdl_stats,quantile_from_sorted_data)(sorted, stridea, ina, 1.0) ;
    double expected = 22;
    gdl_test_rel (top,expected, rel,
                  NAME(gdl_stats) "_quantile_from_sorted_data (100)");
  }

  {
    double median = FUNCTION(gdl_stats,quantile_from_sorted_data)(sorted, stridea, ina, 0.5) ;
    double expected = 18;
    gdl_test_rel (median,expected, rel,
                  NAME(gdl_stats) "_quantile_from_sorted_data (50, even)");
  }

  {
    double median = FUNCTION(gdl_stats,quantile_from_sorted_data)(sorted, stridea, ina - 1, 0.5);
    double expected = 18;
    gdl_test_rel (median,expected, rel,
                  NAME(gdl_stats) "_quantile_from_sorted_data (50, odd)");
  }

  free (sorted);
  free (igroupa);
  free (igroupb);
  free (test1);
}
