/* statistics/variance_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Jim Davies, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static double 
FUNCTION(compute,variance) (const BASE data[], const size_t stride, const size_t n, const double mean);

static double
FUNCTION(compute,variance) (const BASE data[], const size_t stride, const size_t n, const double mean)
{
  /* takes a dataset and finds the variance */

  long double variance = 0 ;

  size_t i, ii;

  /* find the sum of the squares */
  for (ii = i = 0; i < n; i++)
    {
    	if (!gdl_isnan (data[i * stride]))
    	{
	      const long double delta = (data[i * stride] - mean);
	      variance += (delta * delta - variance) / (ii + 1);
	      ii++;
    	}
    }

  return variance ;
}


double 
FUNCTION(gdl_stats,variance_with_fixed_mean) (const BASE data[], const size_t stride, const size_t n, const double mean)
{
  const double variance = FUNCTION(compute,variance) (data, stride, n, mean);
  return variance;
}

double 
FUNCTION(gdl_stats,sd_with_fixed_mean) (const BASE data[], const size_t stride, const size_t n, const double mean)
{
  const double variance = FUNCTION(compute,variance) (data, stride, n, mean);
  const double sd = sqrt (variance);

  return sd;
}



double 
FUNCTION(gdl_stats,variance_m) (const BASE data[], const size_t stride, const size_t n, const double mean)
{
  const double variance = FUNCTION(compute,variance) (data, stride, n, mean);
  
  return variance * ((double)n / (double)(n - 1));
}

double 
FUNCTION(gdl_stats,sd_m) (const BASE data[], const size_t stride, const size_t n, const double mean)
{
  const double variance = FUNCTION(compute,variance) (data, stride, n, mean);
  const double sd = sqrt (variance * ((double)n / (double)(n - 1)));

  return sd;
}

double 
FUNCTION(gdl_stats,variance) (const BASE data[], const size_t stride, const size_t n)
{
  const double mean = FUNCTION(gdl_stats,mean) (data, stride, n);
  return FUNCTION(gdl_stats,variance_m)(data, stride, n, mean);
}

double 
FUNCTION(gdl_stats,sd) (const BASE data[], const size_t stride, const size_t n)
{
  const double mean = FUNCTION(gdl_stats,mean) (data, stride, n);
  return FUNCTION(gdl_stats,sd_m) (data, stride, n, mean);
}
