/*  
 * 	string/file.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <stdio.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_io.h>

gdl_string *
gdl_string_fread (FILE * stream)
{
	int status;
	size_t n;
	char * str;
		
	status = fread (&n, sizeof (size_t), 1, stream);
	GDL_FREAD_STATUS (status, 1);
	str = GDL_CALLOC (char, n);
	status = fread (str, sizeof (char), n, stream);
	GDL_FREAD_STATUS (status, n);
	
	return str;
}

int
gdl_string_fwrite (FILE * stream, const char * str)
{
	int status;
	size_t n;
		
	n = strlen (str);
	n++;
	status = fwrite (&n, sizeof (size_t), 1, stream);
	GDL_FWRITE_STATUS (status, 1);
	status = fwrite (str, sizeof (char), n, stream);
	GDL_FWRITE_STATUS (status, n);
	
	return GDL_SUCCESS;
}

gdl_string **
gdl_string_one_column_file (const gdl_string * filename, size_t * nstr)
{
	size_t n;
	gdl_string * line=0, ** output = 0;
	gdl_list * buffer = gdl_list_alloc (gdl_list_default);
	FILE * stream;
	
	stream = gdl_fileopen (filename, "r");
	
	while(gdl_getline (&line, &n, stream)!=-1)
	{
		gdl_list_push_back (buffer, gdl_string_clone (line), 0);
		gdl_string_free (line);
		line=0;
	}
	
	gdl_fileclose (filename, stream); 
	
	if ((n=gdl_list_size (buffer))!=0)
	{
		size_t i = 0; 
		gdl_list_itr * itr;
		
		(*nstr) = n;
		output  = GDL_MALLOC (gdl_string *, n);
		itr     = gdl_list_iterator_front (buffer);
		do
		{
			output[i++] = gdl_list_iterator_value (itr);
		}
		while(gdl_list_iterator_next (itr));
		gdl_list_iterator_free (itr);
	}
	
	return output;
}
