/* sys/infnan.c
 * 
 * Copyright (C) 2001, 2004 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <math.h>

double gdl_nan (void);
double gdl_posinf (void);
double gdl_neginf (void);
double gdl_fdiv (const double x, const double y);

double
gdl_fdiv (const double x, const double y)
{
  return x / y;
}

double gdl_nan (void)
{
  return gdl_fdiv (0.0, 0.0);
}

double gdl_posinf (void)
{
  return gdl_fdiv (+1.0, 0.0);
}

double gdl_neginf (void)
{
  return gdl_fdiv (-1.0, 0.0);
}

int gdl_isnan (const double x);
int gdl_isinf (const double x);
int gdl_finite (const double x);

int
gdl_isnan (const double x)
{
  int status = (x != x);
  return status;
}

int
gdl_isinf (const double x)
{
  double y = x - x;
  int s = (y != y);

  if (s && x > 0)
    return +1;
  else if (s && x < 0)
    return -1;
  else
    return 0;
}

int
gdl_finite (const double x)
{
  const double y = x - x;
  int status = (y == y);
  return status;
}


