/*  
 * 	util/gdl_util.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_UTIL_H__
#define __GDL_UTIL_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>

#define GDL_ARRAY_FREAD(type, num, stream) \
        ((type *) gdl_array_fread (sizeof(type), (num), (stream)))
#define GDL_ARRAY_FWRITE(vector, type, num, stream) \
        (gdl_array_fwrite ((vector), sizeof(type), (num), (stream)))

__BEGIN_DECLS

gdl_string * gdl_time2ascii (void);
void * gdl_array_fread (size_t atomic, size_t num, FILE * stream);
int gdl_array_fwrite (void * v, size_t atomic, size_t num, FILE * stream);
int gdl_getline (gdl_string ** line, size_t * n, FILE * stream);
int gdl_significant_star_fprintf (FILE * stream, const double value, const double thresh, const double mult, const size_t max);
int gdl_is_number(char *buffer);
int gdl_eoff(FILE *f);

int gdl_progress_bar (FILE * stream, const size_t ncount, const size_t cur, const size_t tot);

__END_DECLS

#endif
