
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_util.h>


void gdl_putline(FILE *fptr, char ch, int len) {
  int i;
  fputc('\n',fptr);
  for ( i=1; i<=len; i++ ) 
    fputc(ch,fptr);
}

void gdl_memory_account(char *buffer)
{
  /*LogTheError("memacct.txt",buffer);*/
  fprintf(stderr,"%s",buffer);
  fflush(stderr);
}

void gdl_log_error(char *filename, char *buffer)
{
  FILE *fptr;

  fptr = gdl_fileopen(filename,"a");
  if (fptr == NULL)
    fptr = gdl_fileopen(filename,"w");
  fprintf(fptr,"%s",buffer);
  gdl_fileclose(filename,fptr);
}

/*
lrtolod converts the likelihood ratio (LR) to the log of the odds (LOD) score.

 LOD = -log10( exp( -LR/2 ) )
 
Because  
  LR  -2ln(L0/L1) 
and 
  LOD = -log10(L0/L1)
*/
//double lrtolod(double lr)
//{
//  double lod;
//  lod = - log10( exp( -lr/2.0 ) );  
//  return(lod);
//}

/*
lrtolod converts the likelihood ratio (LR) to the log of the odds (LOD) score.

 LOD = -log10( exp( -LR/2 ) )
 
Because  
  LR  -2ln(L0/L1) 
and 
  LOD = -log10(L0/L1)
*/
//double lodtolr(double lod)
//{
//  double lr;
//  lr  = 2.0*lod* log(10);
//  return(lr);
//}
/*
  return 0 if ok, -1 if not an number.
*/
int gdl_is_number(char *buffer)
{
  int len,not_int,ii,start;
  not_int = 0;
  len = strlen(buffer);
  if ( buffer[0] == '-' ) 
    start = 1;
  else 
    start = 0;
  for ( ii = start ; ii < len ; ii++ )
    if ( !isdigit(buffer[ii])  )
      not_int = -1;

  return(not_int);
}

int gdl_is_pinteger(char *buffer)
{
  int len,not_int,ii;
  not_int = 0;
  len = strlen(buffer);
  for ( ii = 0 ; ii < len ; ii++ )
    if ( !isdigit(buffer[ii]) )
      not_int = -1;
  if ( not_int == 0 )
    not_int = atoi(buffer);
  return(not_int);
}

int gdl_find_token(int n, int len, char *buffer,char **names) {
  int l;
  for ( l=1; l<=n; l++ )
    if ( !strncmp( buffer, names[l], len ))
      return(l);      
  return(-1);

}

int gdl_nfgets(char *buffer, int nn, FILE *fptr)
{
  int ii;
  char *chptr;
  for (ii = 0; ii < nn; ii++)
    buffer[ii] = '\0';
  chptr = fgets(buffer, nn, fptr);
  for (ii = 0; ii < nn-1 && buffer[ii] != '\n'; ii++);
    if (ii < nn)
      buffer[ii] = '\0';
  return(ii);
}

/*
For:
  MIN_INT < lb < ub < MAX_INT  and ub - lb < MAX_INT
Do:
  Shuffle  v = ivector(lb,ub)
Where:
  gs_rng_uniform() gives a uniform random number in [0.0, 1.0)

foreach i in [lb,ub) in order, pick a random j from (i,ub]
and switch v(i), v(j)

*/
//void gdl_shuffle_ivector(gdl_rng *rng, int *v, int lb, int ub)
//{
//  int i, j, k;
//  for (i = lb; i < ub; i++) {
//    j = i + (int) ((double) (ub - i) * gdl_rng_uniform(rng)) + 1;
//    k = v[i];
//    v[i] = v[j]  ;
//    v[j]   = k;
//    if (j > ub || j <= i)
//      printf("\nlb = %d, i = %d, j = %d, ub = %d\n", lb, i, j, ub);
//  }
//}

//void gdl_shuffle_lvector(gdl_rng *rng, long *v, long lb, long ub)
//{
//  long i, j, k;
//  for (i = lb; i < ub; i++) {
//    j = i + (long) ((double) (ub - i) * gdl_rng_uniform(rng)) + 1;
//    k = v[i];
//    v[i] = v[j]  ;
//    v[j]   = k;
//  }
//}
/* return 0 if no file 1 if file exists */
int
gdl_isfile(const char * filename)
{
  int isf;
  FILE *fptr;
  isf = 0;
  if (*(filename) != '\0') {
    fptr = fopen(filename, "r");
    if (fptr != NULL) {
      isf = 1;
      fclose(fptr);
    }
  }
  return (isf);
}


int gdl_get_int(void)
{
  char buffer[15], ch;
  int ii, ans;
  for (ii = 0; ii < 15; ii++)
    buffer[ii] = '\0';
  while (isspace(ch = getchar()));
  buffer[0] = ch;
  for (ii = 1; ii < 15 && buffer[ii-1]  != '\n'; ii++)
    buffer[ii] = getchar();
  if (ii < 15) {
    buffer[ii-1]   = '\0';
    ans = atoi(buffer);
  }
  else
    ans = -1;
  return (ans);
}

int gdl_get_next_line(char * buffer, int nn, FILE *fileptr)
{
  int ii, ch;
  for (ii = 0; ii < nn; ii++)
    buffer[ii] = '\0';
  for (ii = 0; ((ch = fgetc(fileptr)) != EOF) && (ch != '\n') && (ii < nn); ii++)
    buffer[ii] = ch;
  if (ch != EOF)
    ch = buffer[0];
  return (ch);
}
/**
 * Parse a input string by line
 */
int gdl_get_next_strline(char *buffer, int nn, char *stream, int nh)
{
  int ii, ch;
  for (ii = 0; ii < nn; ii++)
    buffer[ii] = '\0';
  for (ii = nh; ((ch = stream[ii]) != '\0') && (ch != '\n') && (ii < nn+nh); ii++) {
  	buffer[ii-nh] = ch;
  }
  if (ch != '\0')
    ch = ii+1; 
  return (ch);
}

int gdl_get_next_token(char *xtemp, int nn, FILE *fileptr)
{
  int ii, ch;
  for (ii = 0; ii < nn; ii++)
    xtemp[ii] = '\0';
  ch = fgetc(fileptr);
  while (isspace(ch) && ch != EOF )
	 ch = fgetc(fileptr);
  if ( ch != EOF )
  for (ii = 0; ii < nn && !isspace(ch) && ch != EOF; ii++) {
    xtemp[ii] = ch;
    ch = fgetc(fileptr);
  }
  return (ch);
}
/**
 * 
 */
int gdl_get_next_strtoken(char *xtemp, int nn, char *buff, int nh)
{
  int ii, ch, idx;
  for (ii = 0; ii < nn; ii++)
    xtemp[ii] = '\0';
  idx=nh;  
  ch = buff[idx];
  while (isspace(ch) && ch != '\0' )
	 ch = buff[++idx];
  if (ch != '\0')
	  for (ii = 0; ii < nn && !isspace(ch) && ch != '\0'; ii++) {
    	xtemp[ii] = ch;
	    ch = buff[idx+ii+1];
  	  }
  if (ch != '\0')
  	ch = idx+ii;
  	
  return ch;
}
/**
 * Returns a new seed based on the current time.
 * @returns a new seed which is the long value of the current time.
 */
long gdl_get_a_seed(void)
{
  time_t tptr;
  time(&tptr);
#if defined(MACWARRIOR) || defined(WINWARRIOR)
  tptr = tptr / 2L;
#endif
  return ((long) tptr);
}

gdl_string *
gdl_time2ascii (void)
{
  char * time_buffer;
  time_t tptr;
  struct tm * tms;
  size_t i, len;
  
  time_buffer = GDL_MALLOC (char, 100);
  
  for (i = 0; i < 100; i++)
    time_buffer[i] = '\0';
  time(&tptr);
  tms = localtime(&tptr);
  len = strftime(time_buffer, 100, "%H:%M:%S-%d/%B/%Y", tms);
  
  if (len)
	  return time_buffer;
  else
  	  return NULL;
}


#if defined(DSIGN)
double dsign(double val1, double val2)
{
  double xx;
  xx = fabs(val1);
  if (val2 < 0.0)
    xx = -xx;
  return (xx);
}
#endif



/*
 * dtranspose does an arbitrary transpose of one matrix
 * onto another. You must have allocated the memory that
 * mm1 and mm2 have pointed to.  lr, and lc are the initial
 * row and column while ur and uc are the final row and
 * column for the transpositon.  Note that mm1 =
 * dmatrix(lr,ur,lc,uc); mm2 = dmatrix(lc,uc,lr,ur); at
 * least.  These can be bigger, so that one can transpose
 * an arbitrary part of one matrix onto another.
 *
 * By Chris Basten, January 1994
 */
int dtranspose(double **mm1, double **mm2, int lr, int lc, int ur, int uc)
{
  int ii, jj;
  if (lr >= ur || lc >= uc)
    return (1);
  for (ii = lr; ii <= ur; ii++)
    for (jj = lc; jj <= uc; jj++)
      mm2[jj][ii] = mm1[ii][jj];
  return (0);
}



#if defined(ITOA)


/*
 * I have found some of the functions on other machines,
 * namely the Decstation.  Also, the GNU C compiler has
 * them.
 */
char *
     strupr(char *s)
{
  int len, ii;
  if ( s == NULL )
    return(s);
  len = strlen(s);
  for (ii = 0; ii < len; ii++)
    if ( islower(s[ii]) )
      s[ii] = toupper(s[ii]);
  return s;
}

char *
     strlwr(char *s)
{
  int len, ii;
  if ( s == NULL )
    return(s);
  len = strlen(s);
  for (ii = 0; ii < len; ii++) 
    if ( isupper(s[ii]) )
      s[ii] = tolower(s[ii]);
  return(s);
}

#endif


#if defined(DIVT)

div_t
div(int numer, int denom);
{
  div_t x;
  x.quot = 0;
  x.rem = 0;
  if (denom != 0) {
    x.quot = numer / denom;
    x.rem = numer - x.quot * denom;
  }
  else
    fprintf(stderr, "\n\nSorry, divide by zero in _div...\n");
  return x;
}

ldiv_t
ldiv(long numer,long denom);
{
  ldiv_t x;
  x.quot = 0;
  x.rem = 0;
  if (denom != 0) {
    x.quot = numer / denom;
    x.rem = numer - x.quot * denom;
  }
  else
    fprintf(stderr, "\n\nSorry, divide by zero in _ldiv...\n");
  return x;
}
#endif

FILE *gdl_fileopen(const char *name, char *mode)
{
 /* Open files, writing an error message if it fails. */
  FILE *fp = fopen(name, mode);
  if (fp == NULL) {
    printf("Can't open %s for ", name);
    switch (mode[0]) {
     case 'r':
      printf("reading\n");
      break;
     case 'w':
      printf("writing\n");
      break;
     case 'a':
      printf("appending\n");
      break;
     default:
      printf("some strange mode\n");
      break;
    }
  }
  return fp;
}

void gdl_fileclose(const char *name, FILE *fp)
{
 /* Close files, writing an error message if it fails. */
  if (fp != NULL && fclose(fp) == EOF)
    printf("Error closing %s\n", name);
}

void mypause(void)
{
  char answer;
  printf("\nType a <CR> to go on...\n");
  while ((answer = getchar()) != '\n');
}

//void gdl_get_field(int xfield, char *xtemp, char *xbuffer)
//{
//  int i, j, field, look;
//  for (i = 0; i < GDL_MAXNAME; i++)
//     xtemp[i] = '\0';
//  for (i = 0; xbuffer[i] != '\0'; i++);
//  xbuffer[i] = ' ';
//  field = 0;
//  look = 1;
//  for (i = 0; field < xfield && i<GDL_MAXLINE; i++) {
//    if (!isspace(xbuffer[i]) && look == 1) {
//      field = field + 1;
//      look = 0;
//    }
//    if (isspace(xbuffer[i]) && look == 0)
//      look = 1;
//  }
//  if (i < GDL_MAXLINE && field == xfield) {
//  	  for (j = i - 1; !isspace(xbuffer[j]) && j<GDL_MAXLINE; j++)
//   	  		xtemp[j-i+1] = xbuffer[j];
//  }
//}

int Rotator(int thestep) {
  
      if ( thestep == 0 )
        printf(" ");
      else if ( thestep == 1 )
        printf("\b|");
      else if ( thestep == 2 )   
        printf("\b/");
      else if ( thestep == 3 )   
        printf("\b-");
      else if ( thestep == 4 )   
        printf("\b\\");
      else if ( thestep == 5 )   
        printf("\b|");
      else if ( thestep == 6 )   
        printf("\b/");
      else if ( thestep == 7 )   
        printf("\b-");
      else if ( thestep == 8 )  { 
        printf("\b\\");
        thestep = 0;
      } 
        
      fflush(stdout);
      return(thestep+1);
}





void ShowDVector(double *invec, int lb, int ub, int cols) {

  int cntr,i;
  
  cntr = 0;
  printf("\n\n");
  for ( i=lb; i<=ub; i++ ) {
    cntr +=1;
    printf(" %8.4g",invec[i]);
    if ( cntr == cols ) {
      printf("\n");
      cntr = 0;
    }
  
  }
  mypause();
}

void ShowIVector(int *invec, int lb, int ub, int cols) {

  int cntr,i;
  
  cntr = 0;
  printf("\n\n");
  for ( i=lb; i<=ub; i++ ) {
    cntr +=1;
    printf(" %8d",invec[i]);
    if ( cntr == cols ) {
      printf("\n");
      cntr = 0;
    }
  
  }
  mypause();
}
/*
 * This function returns the number of string which
 * are the same between the two vectors of string.
 * Very GREEDY....
 */
int cmatrix_strcmp(char **m1, char **m2, int n1l, int n2l, int n1, int n2) {
	int ii, jj;
	int match = 0;
	for(ii=n1l; ii<n1+n1l; ii++) {
		for(jj=n2l; jj<n2+n2l; jj++) {
			if (strcmp(m1[ii], m2[jj]) == 0)
				match++;
		}
	}
	return match;
}
/*
 * This function picks up from src n value from the 
 * jth and mth elements (m-j+1 must be greater than n)
 * and places them in dest from i to n+i
 */
//void pick_narray(gdl_rng *rng, int *dest, int i, int n, int *src, int j, int m) {
//	int tot = i; 		
//	int ri, kk;
// 	while(tot<=n) {
//		/* Draw an int from 1 to the max index*/
//		ri = (int) ((double)(m-j+1) * gdl_rng_uniform(rng)) + j;		
//	 	/* Check if not exists */
//	 	for(kk=i; kk<tot; kk++)
//	 		if (src[ri] == dest[kk])
//	 			break;
//		/* If not add it to the array */		
//	 	if (kk == tot) 
//	 		dest[tot++] = src[ri];
//	}	
//}
/**
 * Returns the number of tokens in the string
 * @param xtemp a string buffer.
 * @param nn the buffer size.
 * @return the number of tokens in the buffer.
 */
int get_token_number(char *xtemp, int nn) {
  int ii, start, token = 0;
  start = 1;
  for(ii=0; ii<nn; ii++) {
  	if (xtemp[ii] == '\0') break;
    if (start == 1 && !isspace(xtemp[ii])) {
    	token++;
    	start = 0;
  } else if (start == 0 && isspace(xtemp[ii]))
    	start = 1;
  }
  return token;
}
/**
 * Clean a string. All the chars are set to '\0'
 * @param str the string
 * @param nh the first element.
 * @param nn the size of the string (strlen(str)+1)
 */
void gdl_clean_str(char *str, int nh, int nn) {
	int ii;
	if (str != NULL)
		for(ii=nh; ii<nn+nh; ii++) str[ii] = '\0';
}

/**
 * 
 */
void gdl_scan_eoln(FILE *f) 
{ /* eat everything to the end of line or eof*/
  char ch;

  while (!gdl_eoff(f) && !gdl_eoln(f)) 
    gdl_gettc(f);
  if (!gdl_eoff(f)) 
    ch = gdl_gettc(f);
}
/**
 * 
 */
int gdl_eoff(FILE *f)
{ /* check for end of file */
    int ch;

    if (feof(f)) 
      return 1;
    ch = getc(f);
    if (ch == EOF) {
      ungetc(ch, f);
      return 1;
    }
    ungetc(ch, f);
    return 0;
}  /*gdl_eoff*/
/**
 * 
 */
int gdl_eoln(FILE *f)
{ /* check for end of line or eof*/
    int ch;

    ch = getc(f);
    if (ch == EOF)
      return 1;
    ungetc(ch, f);
    return ((ch == '\n') || (ch == '\r'));
}  /*gdl_eoln*/
/**
 * 
 */
char gdl_gettc(FILE* file) 
{ /* catch eof's so that other functions not expecting an eof
   * won't have to worry about it */
  int ch;

  ch=getc(file);

  if (ch == EOF )   {
    puts("Unexpected End of File");
    exit(-1);
  }

  if ( ch == '\r' ) {
    ch = getc(file);
    if ( ch != '\n' )
      ungetc(ch,file);
    ch = '\n';
  }
  return ch;
} /* gdl_gettc */

#define LONG_LINE_LENGTH 1000

int
gdl_getline (gdl_string ** line, size_t * n, FILE * stream)
{
	if (stream)
	{
		int c;
		int newlen, len = (*line) ? strlen(*line) : 0;
		gdl_string * tmp;
		
		*n=0;
		while ((c = fgetc (stream)) != EOF)
		{
			if (c == '\n') break;
			if (*n >= len) 
			{
				newlen=(len) ? 2*len : (int)LONG_LINE_LENGTH;
				tmp=gdl_string_alloc(newlen);
				if (len) memcpy(tmp, *line, sizeof(char)*len);
				GDL_FREE(*line);
				*line=tmp;
				len=newlen;
			}
			(*line)[*n]=c;
			(*n)++;
		}
		if (c == EOF && *n==0)
		{
			gdl_string_free (*line);
			*line = NULL;
			*n    = 0;
			return -1;
		}
		else (*line)[*n]='\0';
		
		return *n;
	}
	gdl_string_free (*line);
	*line = NULL;
	*n    = 0;
	return -1;
}

int
gdl_significant_star_fprintf (FILE * stream, const double value, const double thresh, const double mult, const size_t max)
{
	if (stream)
	{
		size_t i = 0;
		double x = value; 
		
		while (x <= thresh)
		{
			if (!i)
			{
				fprintf (stream, "(");
			}
			i++;
			x *= mult;
			fprintf (stream, "*");
			if (i == max || x > thresh) 
			{
				fprintf (stream, ")");
				break;
			}
		}
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;	
}
