
/*  
 * 	util/prog.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>

int
gdl_progress_bar (FILE * stream, const size_t N, const size_t idx, const size_t tot)
{
	size_t bar_size = tot/N;
	size_t bar_cur  = (idx+1) / bar_size;
	size_t i;
	if (idx)
	{
		for (i = 0; i < N+11; i++) {fprintf(stream, "\b");fflush(stream);}
	}
	fprintf (stream, "0\% |");fflush(stream);
	for (i = 0; i < N; i++)
	{
		if (i < bar_cur) fprintf(stream, "=");
		else fprintf (stream, " ");
		fflush(stream);
	}
	if (idx+1 < tot)
		fprintf (stream, "| %3.0f\%\r", 100*((double)idx+1)/tot);
	else
		fprintf (stream, "| 100\%\n");
	fflush(stream);
}
