/* vector/file_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

TYPE (gdl_vector) *
FUNCTION (gdl_vector, fread) (FILE * stream)
{
  int status = 0;
  TYPE (gdl_vector) * v;
  
  v = GDL_MALLOC (TYPE (gdl_vector), 1);
  
  v->owner  = 1;
  status    = fread (&(v->size), sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS (status, 1);
   status    = fread (&(v->stride), sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS (status, 1);
  v->block = FUNCTION (gdl_block, alloc2) (1, v->size*v->stride);
  v->data  = v->block->data;
  FUNCTION (gdl_block, raw_fread) (stream, v->data, v->size, v->stride);
  
  return v;
}

int
FUNCTION (gdl_vector, fwrite) (FILE * stream, const TYPE (gdl_vector) * v)
{
  int status = 0;
  status    = fwrite (&(v->size), sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS (status, 1);
  status    = fwrite (&(v->stride), sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS (status, 1);
  
  FUNCTION (gdl_block, raw_fwrite) (stream,
                                                 v->data,
                                                 v->size,
                                                 v->stride);
  return GDL_SUCCESS;
}

#if !(USES_LONGDOUBLE && !HAVE_PRINTF_LONGDOUBLE)
int
FUNCTION (gdl_vector, fprintf) (FILE * stream, const TYPE (gdl_vector) * v,
                                const char *format)
{
  int status = 0;
  fprintf (stream, "%d %d\n", v->size, v->stride);
  FUNCTION (gdl_block, raw_fprintf) (stream,
                                                  v->data,
                                                  v->size,
                                                  v->stride,
                                                  format);
  return status;
}

TYPE (gdl_vector) *
FUNCTION (gdl_vector, fscanf) (FILE * stream)
{
  int status = 0;
  size_t size, stride;
  TYPE (gdl_vector) * v;
  
  v = GDL_MALLOC (TYPE (gdl_vector), 1);
  
  fscanf (stream, "%d", &(v->size));
  fscanf (stream, "%d", &(v->stride));
  
  v->owner  = 1;
  v->block = FUNCTION (gdl_block, alloc2) (1, v->size*v->stride);
  v->data  = v->block->data;
  
  
  FUNCTION (gdl_block, raw_fscanf) (stream,
                                                 v->data,
                                                 v->size,
                                                 v->stride);
  return v;
}
#endif

