/* vector/vector_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef HIDE_INLINE_STATIC
BASE
FUNCTION (gdl_vector, get) (const TYPE (gdl_vector) * v, const size_t i)
{
  if (gdl_check_range)
    {
      if (i >= v->size)         /* size_t is unsigned, can't be negative */
        {
          BASE zero = ZERO;
          GDL_ERROR_VAL ("index out of range", GDL_EINVAL, zero);
        }
    }

  /* The following line is a generalization of return v->data[i] */

  return *(BASE *) (v->data + MULTIPLICITY * i * v->stride);
}

void
FUNCTION (gdl_vector, set) (TYPE (gdl_vector) * v, const size_t i, BASE x)
{
  if (gdl_check_range)
    {
      if (i >= v->size)         /* size_t is unsigned, can't be negative */
        {
          GDL_ERROR_VOID ("index out of range", GDL_EINVAL);
        }
    }

  /* The following line is a generalization of v->data[i] = x */

  *(BASE *) (v->data + MULTIPLICITY * i * v->stride) = x;
}

BASE *
FUNCTION (gdl_vector, ptr) (TYPE (gdl_vector) * v, const size_t i)
{
  if (gdl_check_range)
    {
      if (i >= v->size)         /* size_t is unsigned, can't be negative */
        {
          GDL_ERROR_NULL ("index out of range", GDL_EINVAL);
        }
    }

  return (BASE *) (v->data + MULTIPLICITY * i * v->stride);
}

const BASE *
FUNCTION (gdl_vector, const_ptr) (const TYPE (gdl_vector) * v, const size_t i)
{
  if (gdl_check_range)
    {
      if (i >= v->size)         /* size_t is unsigned, can't be negative */
        {
          GDL_ERROR_NULL ("index out of range", GDL_EINVAL);
        }
    }

  /* The following line is a generalization of return v->data[i] */

  return (const BASE *) (v->data + MULTIPLICITY * i * v->stride);
}
#endif
