/*  
 * 	dpca/gdl_workspace.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_WORKSPACE_H__
#define __GDL_WORKSPACE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_runtime.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gmatrix.h>

__BEGIN_DECLS

typedef struct
{
	gdl_gview     * data;
	gdl_runtime   * run;		
} gdl_workspace;

gdl_workspace * gdl_workspace_alloc ();
void gdl_workspace_free (gdl_workspace * w);

void gdl_workspace_attach_data (gdl_workspace * w, gdl_gview * x);

gdl_gview * gdl_workspace_detach_data (gdl_workspace * w);
gdl_gview * gdl_workspace_get_data (gdl_workspace * w);
gdl_runtime   * gdl_workspace_get_runtime (gdl_workspace * w);

__END_DECLS

#endif
