/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.coloredtable.cellrenderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTable;
import javax.swing.border.Border;
import ro.genomeartist.coloredtable.cellrenderers.AbstractColoredCellRenderer;
import ro.genomeartist.components.utils.GraphicRenderingUtils;

public class DefaultColoredCellRenderer
extends AbstractColoredCellRenderer {
    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        int focusMarkerSize = 4;
        int iconWidth = 16;
        Color actualBgColor = this.getBackground();
        Color actualFgColor = this.getForeground();
        Color prefferedBgColor = this.getPrefferedBackground();
        Color prefferedFgColor = this.getPrefferedForeground();
        g2d.setColor(actualBgColor);
        g2d.fillRect(0, 0, width, height);
        this.setBackground(null);
        if (this.isCellEditable()) {
            Color colorRight;
            Color colorLeft;
            boolean isLeftAligned;
            boolean bl = isLeftAligned = this.getHorizontalAlignment() == 2 || this.getHorizontalAlignment() == 10;
            if (this.isSelected()) {
                colorLeft = g2d.getColor();
                colorRight = GraphicRenderingUtils.lightenColor(colorLeft, 2 * this.getColorOffset());
            } else {
                colorLeft = g2d.getColor();
                colorRight = Color.WHITE;
            }
            GraphicRenderingUtils.drawEditableBackground(g2d, colorLeft, colorRight, width, height, iconWidth, isLeftAligned);
            this.setBackground(null);
        }
        if (this.hasSomeFocus()) {
            g2d.setColor(actualFgColor);
            int startX = 0;
            int startY = 0;
            g2d.drawLine(startX, startY, startX, focusMarkerSize);
            g2d.drawLine(startX, startY, focusMarkerSize, startY);
            startX = 0;
            startY = height - 1;
            g2d.drawLine(startX, startY, startX, startY - focusMarkerSize);
            g2d.drawLine(startX, startY, focusMarkerSize, startY);
            startX = width - 1;
            startY = height - 1;
            g2d.drawLine(startX, startY, startX, startY - focusMarkerSize);
            g2d.drawLine(startX, startY, startX - focusMarkerSize, startY);
            startX = width - 1;
            startY = 0;
            g2d.drawLine(startX, startY, startX, focusMarkerSize);
            g2d.drawLine(startX, startY, startX - focusMarkerSize, startY);
        }
        super.paint(g);
    }
}

