/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.jtable.rowheader;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import ro.genomeartist.components.jtable.rowheader.RowAnnotation;
import ro.genomeartist.components.jtable.rowheader.RowHeaderCellData;
import ro.genomeartist.components.jtable.rowheader.RowHeaderModel;
import ro.genomeartist.components.jtable.rowheader.RunnableSuggestion;
import ro.genomeartist.components.jtable.rowheader.implementation.JRowHeaderCellRenderer;
import ro.genomeartist.components.jtable.rowheader.implementation.JSuggestionsPopup;
import ro.genomeartist.components.jtable.rowheader.implementation.PhonyListSelectionModel;

public class JTableRowHeader
extends JList {
    private static final Color DEFAULT_BACKGROUND = new Color(230, 230, 255);
    private static final int NR_OF_CHARS = 4;
    private JTable jtable;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            JList sourceList = (JList)e.getSource();
            if (sourceList != JTableRowHeader.this) {
                return;
            }
            int row = sourceList.locationToIndex(e.getPoint());
            if (row != -1) {
                RowHeaderCellData rowHeaderCellData = (RowHeaderCellData)sourceList.getModel().getElementAt(row);
                JComponent renderedComponent = (JComponent)sourceList.getCellRenderer().getListCellRendererComponent(sourceList, rowHeaderCellData, row, false, false);
                Insets borderInsets = renderedComponent.getBorder().getBorderInsets(renderedComponent);
                Rectangle cellBounds = sourceList.getCellBounds(row, row);
                double offsetRight = cellBounds.getX() + cellBounds.getWidth() - (double)e.getX();
                if (rowHeaderCellData.getRowAnnotationCount() > 1 && offsetRight < (double)borderInsets.right) {
                    JTableRowHeader.this.doActionCycleAnnotations(row);
                    return;
                }
            } else {
                return;
            }
            JTableRowHeader.this.showSuggestionsForRow(row);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            JList sourceList = (JList)e.getSource();
            if (sourceList != JTableRowHeader.this) {
                return;
            }
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            JTableRowHeader.this.showTooltipForRow(row);
        }
    };

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel) {
        this(jtable, listModel, 4);
    }

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel, int cols) {
        this.jtable = jtable;
        this.setSelectionModel(new PhonyListSelectionModel());
        this.setFixedCellHeight(jtable.getRowHeight());
        jtable.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        int charSize = this.getFontMetrics(this.getFont()).charWidth('0');
        this.setFixedCellWidth(charSize * cols);
        this.setModel(listModel);
        this.setCellRenderer(new JRowHeaderCellRenderer());
        this.setBackground(DEFAULT_BACKGROUND);
        this.addMouseListener(this.mouseListener);
    }

    private void checkForHeightChange() {
        int rowHeight = this.jtable.getRowHeight();
        if (rowHeight != this.getFixedCellHeight()) {
            this.setFixedCellHeight(rowHeight);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.checkForHeightChange();
        super.paint(g);
    }

    private void showSuggestionsForRow(int row) {
        Vector<RunnableSuggestion> suggestions;
        Rectangle cellBounds = this.getCellBounds(row, row);
        int popupX = (int)(cellBounds.getX() + cellBounds.getWidth() + 5.0);
        int popupY = (int)(cellBounds.getY() + cellBounds.getHeight());
        RowHeaderCellData cellData = (RowHeaderCellData)this.getModel().getElementAt(row);
        RowAnnotation currentAnnotation = cellData.getCurrentAnnotation();
        if (currentAnnotation != null && (suggestions = currentAnnotation.getSuggestions()) != null && !suggestions.isEmpty()) {
            JSuggestionsPopup suggestionsPopup = new JSuggestionsPopup(suggestions);
            suggestionsPopup.show(this, popupX, popupY);
        }
    }

    private void showTooltipForRow(int row) {
        final JTableRowHeader sourceList = this;
        Rectangle cellBounds = sourceList.getCellBounds(row, row);
        final int middleX = (int)(cellBounds.getX() + cellBounds.getWidth() / 2.0);
        final int middleY = (int)(cellBounds.getY() + cellBounds.getHeight() / 2.0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MouseEvent moveEvent = new MouseEvent(sourceList, 0, 0L, 0, middleX, middleY, 0, false);
                int initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().mouseMoved(moveEvent);
                ToolTipManager.sharedInstance().setInitialDelay(initialDelay);
            }
        });
    }

    private void doActionCycleAnnotations(int row) {
        RowHeaderModel rowModel = (RowHeaderModel)this.getModel();
        rowModel.cycleAnnotations(row);
    }
}

