/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.propertiespanel.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.genomeartist.components.filechooser.filters.ImageSpecificFileFilter;
import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.utils.ImageUtils;

public class JImageChooserPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ActionListener {
    private final Frame rootFrame;
    private JLabel imageLabel;
    private JButton selectButton;
    private JFileChooser fileChooser;
    private BufferedImage storedImage;
    private int width;
    private int height;

    public JImageChooserPropertiesEditor(Frame rootFrame, int columns) {
        this(rootFrame, columns, 100, 100);
    }

    public JImageChooserPropertiesEditor(Frame rootFrame, int columns, int width, int height) {
        this.setLayout(new BorderLayout());
        this.storedImage = null;
        this.width = width;
        this.height = height;
        this.rootFrame = rootFrame;
        this.imageLabel = new JLabel("No image");
        this.imageLabel.setBorder(BorderFactory.createEtchedBorder());
        this.imageLabel.setHorizontalAlignment(4);
        this.imageLabel.setBackground(Color.WHITE);
        this.imageLabel.setOpaque(true);
        this.selectButton = new JButton("..");
        this.add((Component)this.imageLabel, "Center");
        this.add((Component)this.selectButton, "East");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new ImageSpecificFileFilter());
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.selectButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal = this.fileChooser.showOpenDialog(this.rootFrame);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                BufferedImage loadedImage = ImageIO.read(file);
                this.setImage(loadedImage);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private void setImage(BufferedImage image) {
        this.storedImage = image;
        BufferedImage resizedIcon = ImageUtils.resizeImage(image, this.width, this.height);
        this.imageLabel.setText("");
        this.imageLabel.setIcon(new ImageIcon(resizedIcon));
    }

    @Override
    public JComponent getContainerComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.imageLabel;
    }

    @Override
    public void setEditorName(String name) {
        this.setName(name);
        this.imageLabel.setName(name);
    }

    @Override
    public void setValue(Class objectClass, Object renderedObject) {
        if (BufferedImage.class != objectClass) {
            throw new UnsupportedOperationException(objectClass + " not supported in JImageChooserPropertiesEditor");
        }
        this.setImage((BufferedImage)renderedObject);
    }

    @Override
    public Object getValue(Class objectClass) {
        if (BufferedImage.class == objectClass) {
            return this.storedImage;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JImageChooserPropertiesEditor");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.imageLabel.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
    }

    @Override
    public void addEditorChangeListener(IEditorChangeListener listener) {
    }

    @Override
    public void removeEditorChangeListener(IEditorChangeListener listener) {
    }
}

