/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.textfield.fixedwidth;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.JTextField;
import ro.genomeartist.components.popup.CopyPastePopupManager;

public class JFixedWidthTextField
extends JTextField {
    public JFixedWidthTextField() {
        this(0);
    }

    public JFixedWidthTextField(int width) {
        this("", width);
    }

    public JFixedWidthTextField(String text, int width) {
        super(text);
        this.configureFixedWidth(width);
        this.setCopyPastePopupEnabled(true);
    }

    public void setFixedWidth(int width) {
        this.configureFixedWidth(width);
    }

    public void setCopyPastePopupEnabled(boolean shouldEnable) {
        MouseListener popupTrigger = CopyPastePopupManager.getCopyPastePopup().getPopupTrigger();
        this.removeMouseListener(popupTrigger);
        if (shouldEnable) {
            this.addMouseListener(popupTrigger);
        }
    }

    private void configureFixedWidth(int width) {
        if (width > 0) {
            int columnWidth = this.getColumnWidth();
            this.setColumns(width / columnWidth);
            this.setMaximumSize(new Dimension(width, width));
        }
    }
}

