/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import ro.genomeartist.components.glasspane.IDoScreenshot;
import ro.genomeartist.components.glasspane.JGlasspaneMessage;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.JProgressSwingWorker;
import ro.genomeartist.components.tabbedpane.JDragableTabbedPane;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.externalcalls.GenomeArtistFileFilter;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.controller.query.SearchQuery;
import ro.genomeartist.gui.controller.settings.GeneralSettings;
import ro.genomeartist.gui.dialogs.JSearchQueryDialog;
import ro.genomeartist.gui.dialogs.JSettingsDialog;
import ro.genomeartist.gui.icons.JBrandingImages;
import ro.genomeartist.gui.icons.JToolbarFereastraIcons;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.mainpanels.JSearchResultPaneManager;
import ro.genomeartist.gui.utils.JMyBoolean;
import ro.genomeartist.gui.utils.MyGlobalClasses;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;
import ro.genomeartist.gui.utils.ReadWriteConfiguration;

public class RootFrame
extends JFrame
implements IDoScreenshot,
IGlobalManager {
    private static final String LOOKANDFEEL = "System";
    private static final String THEME = "Ocean";
    private Container contentPane;
    private JLayeredPane layeredPane;
    private JGlasspaneMessage glassPane;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private JTabbedPane tabbedpane;
    private JPanel middlePane;
    private JFileChooser fc;
    private static final String NAME_SEARCH = "New Search";
    private static final String NAME_SAVE = "Save";
    private static final String NAME_LOAD = "Load";
    private static final String NAME_SAVE_AS = "Save As";
    private static final String NAME_SETTINGS = "Settings";
    private static final String NAME_EXIT = "Exit";
    private static final String ACTION_SEARCH = "New Search".toLowerCase();
    private static final String ACTION_SAVE = "Save".toLowerCase();
    private static final String ACTION_LOAD = "Load".toLowerCase();
    private static final String ACTION_SAVE_AS = "Save As".toLowerCase();
    private static final String ACTION_SETTINGS = "Settings".toLowerCase();
    private static final String ACTION_EXIT = "Exit".toLowerCase();
    GeneralSettings generalSettings;
    ActionListener menuListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (ACTION_SEARCH.equals(cmd)) {
                RootFrame.this.fireActionSearch();
            } else if (ACTION_SAVE.equals(cmd)) {
                RootFrame.this.fireActionSave();
            } else if (ACTION_LOAD.equals(cmd)) {
                RootFrame.this.fireActionLoad();
            } else if (ACTION_SAVE_AS.equals(cmd)) {
                RootFrame.this.fireActionSaveAs();
            } else if (ACTION_SETTINGS.equals(cmd)) {
                RootFrame.this.fireActionShowSettings();
            } else if (ACTION_EXIT.equals(cmd)) {
                RootFrame.this.fireActionExit();
            }
        }
    };
    ChangeListener tpaneListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tpane = (JTabbedPane)e.getSource();
            Component component = tpane.getSelectedComponent();
        }
    };
    WindowListener windowListener = new WindowListener(){

        public void windowClosing(WindowEvent e) {
            RootFrame.this.fireActionExit();
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    };

    public RootFrame() {
        super("Genome ARTIST");
        ReadOnlyConfiguration.init();
        ReadWriteConfiguration.init();
        MyGlobalClasses.init();
        this.generalSettings = new GeneralSettings();
        this.generalSettings.loadFromFile();
        this.initLookAndFeel();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setSize(dimension);
        this.setExtendedState(6);
        this.setUndecorated(false);
        this.initLogoImages();
        this.layeredPane = this.getLayeredPane();
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.glassPane = new JGlasspaneMessage("Running query", "(please wait)", (IDoScreenshot)this);
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.setVisible(false);
        this.menuBar = this.createMenuBar();
        this.menuBar.setName("menubar");
        this.setJMenuBar(this.menuBar);
        this.toolBar = this.createToolBar();
        this.toolBar.setName("toolbar");
        this.contentPane.add((Component)this.toolBar, "North");
        this.middlePane = this.createMiddle();
        this.contentPane.add(this.middlePane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowListener);
    }

    private void initLogoImages() {
        Vector<Image> imagePack = new Vector<Image>();
        String iconsFolder = ReadOnlyConfiguration.getString("BRANDING_FOLDER");
        String iconsPath = iconsFolder + ReadOnlyConfiguration.getString("LOGO_24");
        Image image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("LOGO_36");
        image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("LOGO_48");
        image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("LOGO_64");
        image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("ARTIST_24");
        image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("ARTIST_36");
        image = MyUtils.createImage(iconsPath);
        imagePack.add(image);
        this.setIconImages(imagePack);
    }

    private void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals(LOOKANDFEEL)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: System");
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                if (LOOKANDFEEL.equals("Metal")) {
                    if (THEME.equals("DefaultMetal")) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (THEME.equals(THEME)) {
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                    }
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:" + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }

    public void pornesteInitializare() {
        AbstractProgressCallable<Boolean> startServerCallable = ExternalLink.getStartServerCallable();
        JProgressSwingWorker startServerWorker = new JProgressSwingWorker((Frame)this, "Loading genomes", startServerCallable, 0);
        startServerWorker.executeTask();
    }

    public Frame getTheRootFrame() {
        return this;
    }

    public void turnOnGlasspane(boolean flag) {
        if (flag) {
            this.glassPane.showGlassPane();
        } else {
            this.glassPane.setVisible(false);
        }
    }

    public void setGlasspaneMessage(String row1, String row2) {
        this.glassPane.setMessage(row1, row2);
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu menu1 = new JMenu("File");
        JMenuItem item = new JMenuItem(NAME_SEARCH);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_SEARCH);
        menu1.add(item);
        item = new JMenuItem(NAME_SETTINGS);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_SETTINGS);
        menu1.add(item);
        menu1.addSeparator();
        item = new JMenuItem(NAME_LOAD);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_LOAD);
        menu1.add(item);
        item = new JMenuItem(NAME_SAVE);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_SAVE);
        menu1.add(item);
        item = new JMenuItem(NAME_SAVE_AS);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_SAVE_AS);
        menu1.add(item);
        menu1.addSeparator();
        item = new JMenuItem(NAME_EXIT);
        item.addActionListener(this.menuListener);
        item.setActionCommand(ACTION_EXIT);
        menu1.add(item);
        mb.add(menu1);
        return mb;
    }

    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Still draggable");
        JToolbarFereastraIcons iconProvider = (JToolbarFereastraIcons)MyGlobalClasses.get((String)"JToolbarFereastraIcons");
        this.fc = new JFileChooser();
        this.fc.addChoosableFileFilter(new GenomeArtistFileFilter());
        this.fc.setAcceptAllFileFilterUsed(false);
        JButton button = null;
        button = new JButton(NAME_SEARCH);
        button.setActionCommand(ACTION_SEARCH);
        button.addActionListener(this.menuListener);
        button.setToolTipText("Start a new search");
        button.setIcon(iconProvider.getIcon(4));
        button.setFocusable(false);
        localToolBar.add(button);
        button = new JButton(NAME_SETTINGS);
        button.setActionCommand(ACTION_SETTINGS);
        button.addActionListener(this.menuListener);
        button.setToolTipText("Open settings");
        button.setIcon(iconProvider.getIcon(5));
        button.setFocusable(false);
        localToolBar.add(button);
        localToolBar.addSeparator();
        button = new JButton(NAME_LOAD);
        button.setActionCommand(ACTION_LOAD);
        button.addActionListener(this.menuListener);
        button.setToolTipText("Load a result");
        button.setIcon(iconProvider.getIcon(2));
        button.setFocusable(false);
        localToolBar.add(button);
        button = new JButton(NAME_SAVE);
        button.setActionCommand(ACTION_SAVE);
        button.addActionListener(this.menuListener);
        button.setToolTipText("Save a result");
        button.setIcon(iconProvider.getIcon(1));
        button.setFocusable(false);
        localToolBar.add(button);
        button = new JButton(NAME_SAVE_AS);
        button.setActionCommand(ACTION_SAVE_AS);
        button.addActionListener(this.menuListener);
        button.setToolTipText("Save a result");
        button.setIcon(iconProvider.getIcon(3));
        button.setFocusable(false);
        localToolBar.add(button);
        JBrandingImages brandingImages = (JBrandingImages)MyGlobalClasses.get((String)"JBrandingImages");
        localToolBar.add(Box.createHorizontalGlue());
        JLabel sigla = new JLabel();
        sigla.setIcon(brandingImages.getIcon(1));
        localToolBar.add(sigla);
        localToolBar.setFocusable(false);
        localToolBar.setFloatable(false);
        localToolBar.setRollover(false);
        return localToolBar;
    }

    private JPanel createMiddle() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.tabbedpane = this.createTabbedPane();
        panel.add(this.tabbedpane);
        return panel;
    }

    private JTabbedPane createTabbedPane() {
        JDragableTabbedPane tpane = new JDragableTabbedPane();
        tpane.addChangeListener(this.tpaneListener);
        return tpane;
    }

    public BufferedImage takeScreenshot() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        this.layeredPane.paint(g2d);
        return image;
    }

    public void refresh() {
        this.layeredPane.revalidate();
    }

    public void fireActionSearch() {
        JMyBoolean isOk = new JMyBoolean();
        JSearchQueryDialog searchDialog = new JSearchQueryDialog(this, NAME_SEARCH, true, isOk);
        searchDialog.setVisible(true);
        if (isOk.isTrue()) {
            MainResult mainResult = null;
            SearchQuery localQuery = searchDialog.getSearchQuery();
            String outputPath = ReadOnlyConfiguration.getString("FOLDER_OUTPUTS");
            outputPath = outputPath + MyUtils.getRandomFileName();
            File outputFile = new File(outputPath);
            AbstractProgressCallable<Boolean> callable = ExternalLink.getSearchCallable(localQuery, outputFile);
            JProgressSwingWorker searchWorker = new JProgressSwingWorker(this.getTheRootFrame(), "Computing", callable, 1);
            searchWorker.setStandardErrorMessage("Error while searching");
            Boolean hasSucceded = (Boolean)searchWorker.executeTask();
            if (hasSucceded != null && hasSucceded.booleanValue()) {
                mainResult = ExternalLink.readResultFile(outputFile);
                mainResult.backgroundFile = outputFile;
                mainResult.isSaved = false;
                mainResult.hasBeenModified = true;
                JSearchResultPaneManager resultPane = new JSearchResultPaneManager(this, mainResult);
                this.tabbedpane.add(mainResult.infoQuery.queryName, resultPane);
                this.tabbedpane.setSelectedComponent(resultPane);
            }
        }
    }

    public void fireActionLoad() {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            final File file = this.fc.getSelectedFile();
            this.glassPane.setMessage("Opening file", "(please wait)");
            this.glassPane.showGlassPane();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainResult mainResult = ExternalLink.readResultFile(file);
                    if (mainResult == null) {
                        JOptionPane.showMessageDialog(RootFrame.this, "Error opening file", "Error", 0);
                        RootFrame.this.glassPane.setVisible(false);
                        return;
                    }
                    mainResult.backgroundFile = file;
                    mainResult.isSaved = true;
                    mainResult.hasBeenModified = false;
                    JSearchResultPaneManager resultPane = new JSearchResultPaneManager(RootFrame.this, mainResult);
                    RootFrame.this.tabbedpane.add(mainResult.infoQuery.queryName, resultPane);
                    RootFrame.this.tabbedpane.setSelectedComponent(resultPane);
                    RootFrame.this.glassPane.setVisible(false);
                }
            });
        }
    }

    public void fireActionSave() {
        JSearchResultPaneManager selectedComponent = (JSearchResultPaneManager)this.tabbedpane.getSelectedComponent();
        if (selectedComponent != null) {
            final MainResult mainResult = selectedComponent.getMainResult();
            if (!mainResult.isSaved) {
                this.fireActionSaveAs();
                return;
            }
            this.glassPane.setMessage("Saving file", "(please wait)");
            this.glassPane.showGlassPane();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    File source = mainResult.backgroundFile;
                    ExternalLink.saveBestResult(mainResult);
                    mainResult.isSaved = true;
                    mainResult.hasBeenModified = false;
                    RootFrame.this.glassPane.setVisible(false);
                }
            });
        }
    }

    public void fireActionSaveAs() {
        int returnVal;
        final JSearchResultPaneManager selectedComponent = (JSearchResultPaneManager)this.tabbedpane.getSelectedComponent();
        if (selectedComponent != null && (returnVal = this.fc.showSaveDialog(this)) == 0) {
            File selectedFile = this.fc.getSelectedFile();
            String basename = MyUtils.getBasename(selectedFile);
            basename = basename + ".ga";
            System.out.println(basename);
            final File destination = new File(basename);
            this.glassPane.setMessage("Saving file", "(please wait)");
            this.glassPane.showGlassPane();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainResult mainResult = selectedComponent.getMainResult();
                    File source = mainResult.backgroundFile;
                    ExternalLink.saveBestResult(mainResult);
                    ExternalLink.copyFile(source, destination);
                    mainResult.backgroundFile = destination;
                    mainResult.isSaved = true;
                    mainResult.hasBeenModified = false;
                    RootFrame.this.glassPane.setVisible(false);
                }
            });
        }
    }

    public void fireActionShowSettings() {
        JSettingsDialog settingsDialog = new JSettingsDialog(this, NAME_SETTINGS, true, this.generalSettings);
        ((Dialog)((Object)settingsDialog)).setVisible(true);
    }

    public void fireActionExit() {
        ExternalLink.stopClient();
        ExternalLink.stopServer();
        System.exit(0);
    }
}

