/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.settings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class AlgorithmParams {
    private static final String NAME_OFFSET = "EXPANSION_OFFSET_ZERO";
    private static final String NAME_MATCH = "EXPANSION_SCORE_MATCH";
    private static final String NAME_MISMATCH = "EXPANSION_SCORE_MISMATCH";
    private static final String NAME_LENGTH_MOD = "EXPANSION_LENGTH_MODIFIER";
    private static final String NAME_PICK_DEPTH = "PICKING_SORT_DEPTH";
    private static final String NAME_NUCLEU = "COMPUNERE_LUNGIME_MINIMA_NUCLEU";
    private static final String NAME_SOLUTII = "COMPUNERE_NUMAR_MAXIM_SOLUTII";
    private static final String NAME_BONUS_COMPUNERE = "COMPUNERE_GENOM_TRANSPOSON_BONUS";
    private static final ExpansionParameters EXPANSION_SHORT = new ExpansionParameters(-5, 4, -2, 4);
    private static final ExpansionParameters EXPANSION_MEDIUM = new ExpansionParameters(-4, 2, 0, 4);
    private static final ExpansionParameters EXPANSION_LONG = new ExpansionParameters(-3, 2, 0, 4);
    private static final int BOOL_FALSE = 0;
    private static final int BOOL_TRUE = 1;
    private int offsetZero;
    private int scoreMatch;
    private int scoreMismatch;
    private int lengthModifier;
    private int pickingDepth;
    private int nucleu;
    private int solutii;
    private boolean bonusCompunere;

    public ExpansionType getExpansionType() {
        ExpansionParameters currentParameters = new ExpansionParameters(this.offsetZero, this.scoreMatch, this.scoreMismatch, this.lengthModifier);
        return AlgorithmParams.getExpansionType(currentParameters);
    }

    public int getOffsetZero() {
        return this.offsetZero;
    }

    public int getScoreMatch() {
        return this.scoreMatch;
    }

    public int getScoreMismatch() {
        return this.scoreMismatch;
    }

    public int getLengthModifier() {
        return this.lengthModifier;
    }

    public int getPickingDepth() {
        return this.pickingDepth;
    }

    public int getNucleu() {
        return this.nucleu;
    }

    public int getSolutii() {
        return this.solutii;
    }

    public boolean isBonusCompunere() {
        return this.bonusCompunere;
    }

    public boolean setOffsetZero(int offsetZero) {
        if (this.offsetZero != offsetZero) {
            this.offsetZero = offsetZero;
            return true;
        }
        return false;
    }

    public boolean setScoreMatch(int scoreMatch) {
        if (this.scoreMatch != scoreMatch) {
            this.scoreMatch = scoreMatch;
            return true;
        }
        return false;
    }

    public boolean setScoreMismatch(int scoreMismatch) {
        if (this.scoreMismatch != scoreMismatch) {
            this.scoreMismatch = scoreMismatch;
            return true;
        }
        return false;
    }

    public boolean setLengthModifier(int lengthModifier) {
        if (this.lengthModifier != lengthModifier) {
            this.lengthModifier = lengthModifier;
            return true;
        }
        return false;
    }

    public boolean setPickingDepth(int pickingDepth) {
        if (this.pickingDepth != pickingDepth) {
            this.pickingDepth = pickingDepth;
            return true;
        }
        return false;
    }

    public boolean setNucleu(int nucleu) {
        if (this.nucleu != nucleu) {
            this.nucleu = nucleu;
            return true;
        }
        return false;
    }

    public boolean setSolutii(int solutii) {
        if (this.solutii != solutii) {
            this.solutii = solutii;
            return true;
        }
        return false;
    }

    public boolean setBonusCompunere(boolean bonusCompunere) {
        if (this.bonusCompunere != bonusCompunere) {
            this.bonusCompunere = bonusCompunere;
            return true;
        }
        return false;
    }

    public void loadFromFile() {
        try {
            String line;
            String paramfile = ReadOnlyConfiguration.getString("PARAM_SERVER");
            BufferedReader fileReader = new BufferedReader(new FileReader(paramfile));
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("#") || line.indexOf("=") == -1) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String leftToken = st.nextToken();
                String rightToken = st.nextToken();
                String key = new String();
                StringTokenizer aux = new StringTokenizer(leftToken, " \t");
                if (aux.hasMoreTokens()) {
                    key = key + aux.nextToken();
                }
                while (aux.hasMoreTokens()) {
                    key = key + " " + aux.nextToken();
                }
                String value = new String();
                aux = new StringTokenizer(rightToken, " \t");
                if (aux.hasMoreTokens()) {
                    value = value + aux.nextToken();
                }
                while (aux.hasMoreTokens()) {
                    value = value + " " + aux.nextToken();
                }
                if (NAME_OFFSET.equals(key)) {
                    this.offsetZero = Integer.parseInt(value);
                    continue;
                }
                if (NAME_MATCH.equals(key)) {
                    this.scoreMatch = Integer.parseInt(value);
                    continue;
                }
                if (NAME_MISMATCH.equals(key)) {
                    this.scoreMismatch = Integer.parseInt(value);
                    continue;
                }
                if (NAME_LENGTH_MOD.equals(key)) {
                    this.lengthModifier = Integer.parseInt(value);
                    continue;
                }
                if (NAME_PICK_DEPTH.equals(key)) {
                    this.pickingDepth = Integer.parseInt(value);
                    continue;
                }
                if (NAME_NUCLEU.equals(key)) {
                    this.nucleu = Integer.parseInt(value);
                    continue;
                }
                if (NAME_SOLUTII.equals(key)) {
                    this.solutii = Integer.parseInt(value);
                    continue;
                }
                if (!NAME_BONUS_COMPUNERE.equals(key)) continue;
                int bool = Integer.parseInt(value);
                if (bool == 0) {
                    this.bonusCompunere = false;
                    continue;
                }
                this.bonusCompunere = true;
            }
            fileReader.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveToFile() {
        try {
            String paramfile = ReadOnlyConfiguration.getString("PARAM_SERVER");
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(paramfile, false));
            fileWriter.write(NAME_OFFSET);
            fileWriter.write(" = ");
            fileWriter.write(this.offsetZero + "");
            fileWriter.newLine();
            fileWriter.write(NAME_MATCH);
            fileWriter.write(" = ");
            fileWriter.write(this.scoreMatch + "");
            fileWriter.newLine();
            fileWriter.write(NAME_MISMATCH);
            fileWriter.write(" = ");
            fileWriter.write(this.scoreMismatch + "");
            fileWriter.newLine();
            fileWriter.write(NAME_LENGTH_MOD);
            fileWriter.write(" = ");
            fileWriter.write(this.lengthModifier + "");
            fileWriter.newLine();
            fileWriter.write(NAME_PICK_DEPTH);
            fileWriter.write(" = ");
            fileWriter.write(this.pickingDepth + "");
            fileWriter.newLine();
            fileWriter.write(NAME_NUCLEU);
            fileWriter.write(" = ");
            fileWriter.write(this.nucleu + "");
            fileWriter.newLine();
            fileWriter.write(NAME_SOLUTII);
            fileWriter.write(" = ");
            fileWriter.write(this.solutii + "");
            fileWriter.newLine();
            fileWriter.write(NAME_BONUS_COMPUNERE);
            fileWriter.write(" = ");
            if (this.bonusCompunere) {
                fileWriter.write("1");
            } else {
                fileWriter.write("0");
            }
            fileWriter.newLine();
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ReadOnlyConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ExpansionType getExpansionType(ExpansionParameters currentParameters) {
        if (EXPANSION_SHORT.equals(currentParameters)) {
            return ExpansionType.SHORT;
        }
        if (EXPANSION_MEDIUM.equals(currentParameters)) {
            return ExpansionType.MEDIUM;
        }
        if (EXPANSION_LONG.equals(currentParameters)) {
            return ExpansionType.LONG;
        }
        return ExpansionType.CUSTOM;
    }

    public ExpansionParameters getExpansionParameters(ExpansionType expansionType) {
        switch (expansionType) {
            case SHORT: {
                return EXPANSION_SHORT;
            }
            case MEDIUM: {
                return EXPANSION_MEDIUM;
            }
            case LONG: {
                return EXPANSION_LONG;
            }
            case CUSTOM: {
                return new ExpansionParameters(this.offsetZero, this.scoreMatch, this.scoreMismatch, this.lengthModifier);
            }
        }
        throw new AssertionError();
    }

    public static class ExpansionParameters {
        private int offsetZero;
        private int scoreMatch;
        private int scoreMismatch;
        private int lengthModifier;

        public ExpansionParameters(int offsetZero, int scoreMatch, int scoreMismatch, int lengthModifier) {
            this.offsetZero = offsetZero;
            this.scoreMatch = scoreMatch;
            this.scoreMismatch = scoreMismatch;
            this.lengthModifier = lengthModifier;
        }

        public int getLengthModifier() {
            return this.lengthModifier;
        }

        public int getOffsetZero() {
            return this.offsetZero;
        }

        public int getScoreMatch() {
            return this.scoreMatch;
        }

        public int getScoreMismatch() {
            return this.scoreMismatch;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpansionParameters other = (ExpansionParameters)obj;
            if (this.offsetZero != other.offsetZero) {
                return false;
            }
            if (this.scoreMatch != other.scoreMatch) {
                return false;
            }
            if (this.scoreMismatch != other.scoreMismatch) {
                return false;
            }
            return this.lengthModifier == other.lengthModifier;
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + this.offsetZero;
            hash = 59 * hash + this.scoreMatch;
            hash = 59 * hash + this.scoreMismatch;
            hash = 59 * hash + this.lengthModifier;
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpansionType {
        SHORT,
        MEDIUM,
        LONG,
        CUSTOM;


        public String toString() {
            switch (this) {
                case SHORT: {
                    return "Short";
                }
                case MEDIUM: {
                    return "Medium";
                }
                case LONG: {
                    return "Long";
                }
                case CUSTOM: {
                    return "Custom";
                }
            }
            throw new AssertionError();
        }
    }
}

