/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import java.awt.Component;
import ro.genomeartist.components.dialogs.JTwoButtonAbstractDialog;
import ro.genomeartist.components.propertiespanel.AbstractPropertiesPanelModel;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.propertiespanel.IPropertiesHeader;
import ro.genomeartist.components.propertiespanel.JPropertiesPanel;
import ro.genomeartist.components.propertiespanel.editors.JCheckBoxPropertiesEditor;
import ro.genomeartist.components.propertiespanel.editors.JTextAreaPropertiesEditor;
import ro.genomeartist.components.propertiespanel.editors.JTextFieldPropertiesEditor;
import ro.genomeartist.components.propertiespanel.headers.JLabelPropertiesHeader;
import ro.genomeartist.gui.controller.query.SearchQuery;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.utils.DNAUtils;
import ro.genomeartist.gui.utils.JMyBoolean;

public class JSearchQueryDialog
extends JTwoButtonAbstractDialog {
    private static final String BUTTON_SEARCH = "  Search  ";
    private static final String BUTTON_CANCEL = "  Cancel  ";
    private SearchQuery searchQuery;
    private JMyBoolean isOk;
    JPropertiesPanel propertiesPanel;
    MyPropertiesModel propertiesPanelModel;

    public JSearchQueryDialog(IGlobalManager globalManager, String title, boolean modal, JMyBoolean isOk) {
        super(globalManager.getTheRootFrame(), title, modal);
        this.isOk = isOk;
        this.searchQuery = new SearchQuery("query_001", "");
        this.setTextOk(BUTTON_SEARCH);
        this.setTextCancel(BUTTON_CANCEL);
        this.setResizable(true);
        this.propertiesPanelModel = new MyPropertiesModel();
        this.propertiesPanel = new JPropertiesPanel((AbstractPropertiesPanelModel)this.propertiesPanelModel);
        this.setCenterComponent((Component)this.propertiesPanel);
        this.pack();
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    public void fireActionOk() {
        boolean hasChanged = true;
        boolean bl = hasChanged = this.propertiesPanel.commitChanges() || hasChanged;
        if (hasChanged) {
            this.dispose();
            this.isOk.setTrue();
        } else {
            this.dispose();
            this.isOk.setFalse();
        }
    }

    public void fireActionCancel() {
        this.dispose();
        this.isOk.setFalse();
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    private class MyPropertiesModel
    extends AbstractPropertiesPanelModel {
        private static final int FIELD_ROWS = 10;
        private static final int FIELD_WIDTH = 350;
        private static final int LABEL_WIDTH = 150;
        private static final int TEXTAREA_HEIGHT = 150;
        public static final int ROW_NAME = 0;
        public static final int ROW_CONTENT = 1;
        public static final int ROW_IS_REVERSE_COMPLEMENT = 2;

        public int getRowCount() {
            return 3;
        }

        public int getLabelWidth() {
            return 150;
        }

        public Class getClassAt(int row) {
            switch (row) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            assert (false);
            return null;
        }

        public String getDescriptionAt(int row) {
            switch (row) {
                case 0: {
                    return "Query name";
                }
                case 1: {
                    return "Query content";
                }
                case 2: {
                    return null;
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesEditor createEditorComponentAt(int row) {
            switch (row) {
                case 0: {
                    return new JTextFieldPropertiesEditor(350);
                }
                case 1: {
                    return new JTextAreaPropertiesEditor(10, 350);
                }
                case 2: {
                    return new JCheckBoxPropertiesEditor("Reverse complement query");
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesHeader createHeaderComponentAt(int row) {
            switch (row) {
                case 0: {
                    return new JLabelPropertiesHeader("Query");
                }
            }
            return null;
        }

        public void fireActionRowChanged(int row) {
            switch (row) {
                case 2: {
                    String currentQueryContent = (String)this.getEditorComponentAt(1).getValue(String.class);
                    String sanitieSequence = DNAUtils.sanitizeSequence(currentQueryContent);
                    String reverseComplementedContent = DNAUtils.reverseComplementSequence(sanitieSequence);
                    this.getEditorComponentAt(1).setValue(String.class, (Object)reverseComplementedContent);
                    break;
                }
            }
        }

        public boolean isRowOnNewline(int row) {
            switch (row) {
                default: 
            }
            return true;
        }

        public int getRowHeightAt(int row) {
            switch (row) {
                case 1: {
                    return 150;
                }
            }
            return 0;
        }

        public Object getValueAt(int row) {
            switch (row) {
                case 0: {
                    return JSearchQueryDialog.this.searchQuery.getQueryName();
                }
                case 1: {
                    return JSearchQueryDialog.this.searchQuery.getQueryContent();
                }
                case 2: {
                    return false;
                }
            }
            assert (false);
            return null;
        }

        public boolean setValueAt(int row, Object newValue) {
            Boolean hasChanged;
            Object oldValue = this.getValueAt(row);
            if (oldValue != null ? this.getValueAt(row).equals(newValue) : newValue == null) {
                return false;
            }
            switch (row) {
                case 0: {
                    String auxString = (String)newValue;
                    hasChanged = JSearchQueryDialog.this.searchQuery.setQueryName(auxString);
                    break;
                }
                case 1: {
                    String auxString = (String)newValue;
                    hasChanged = JSearchQueryDialog.this.searchQuery.setQueryContent(auxString);
                    break;
                }
                case 2: {
                    hasChanged = false;
                    break;
                }
                default: {
                    hasChanged = false;
                }
            }
            return hasChanged;
        }
    }
}

